/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.pingcommons.upgrade.file;

import com.pingidentity.pingcommons.upgrade.file.AbstractFileMigrator;
import com.pingidentity.pingcommons.upgrade.file.FileMigrationException;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RenameDefaultsFileMigrator
extends AbstractFileMigrator {
    private static final Logger logger = LoggerFactory.getLogger(RenameDefaultsFileMigrator.class);
    private final String destinationVersion;

    public RenameDefaultsFileMigrator(String destinationVersion) {
        this.destinationVersion = destinationVersion;
    }

    @Override
    public void migrate(Path sourceFilePath, Path destinationFilePath, Path defaultFilePath) throws FileMigrationException {
        String renamedFilename = FilenameUtils.getBaseName((String)destinationFilePath.getFileName().toString()) + "-default-" + this.destinationVersion + "." + FilenameUtils.getExtension((String)destinationFilePath.getFileName().toString());
        Path renamedDestinationPath = destinationFilePath.resolveSibling(renamedFilename);
        try {
            Files.move(destinationFilePath, renamedDestinationPath, new CopyOption[0]);
            logger.info("Renamed {} to {}", (Object)destinationFilePath, (Object)renamedDestinationPath);
        }
        catch (IOException e) {
            logger.warn("Unable to rename " + destinationFilePath + " to " + renamedDestinationPath);
        }
        try {
            Files.copy(sourceFilePath, destinationFilePath, StandardCopyOption.REPLACE_EXISTING);
            logger.info("Copied {} to {}", (Object)sourceFilePath, (Object)destinationFilePath);
        }
        catch (IOException e) {
            throw new FileMigrationException("Unable to copy " + sourceFilePath + " to " + destinationFilePath, e);
        }
    }
}

