/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.access;

import com.pingidentity.sdk.internal.interfaces.SdkJwkWrapper;
import com.pingidentity.sdk.internal.services.ArgPair;
import com.pingidentity.sdk.internal.services.ServiceFactory;
import com.pingidentity.sdk.internal.services.interfaces.JwksEndpointKeyAccessorService;
import java.security.PrivateKey;
import java.util.List;
import org.jose4j.jwk.JsonWebKey;
import org.jose4j.jwk.JsonWebKeySet;

public final class JwksEndpointKeyAccessor {
    private final JwksEndpointKeyAccessorService jwkFacilitator = ServiceFactory.getSingleImpl(JwksEndpointKeyAccessorService.class, new ArgPair[0]);

    public static JwksEndpointKeyAccessor newInstance() {
        return new JwksEndpointKeyAccessor();
    }

    private JwksEndpointKeyAccessor() {
    }

    @Deprecated
    public JsonWebKeyWrapper getCurrentRsaKey() {
        SdkJwkWrapper currentRsaKey = this.jwkFacilitator.getCurrentRsaKey(null);
        return currentRsaKey != null ? new JsonWebKeyWrapper(currentRsaKey) : null;
    }

    public JsonWebKeyWrapper getCurrentRsaKey(String signingAlgorithm) {
        SdkJwkWrapper currentRsaKey = this.jwkFacilitator.getCurrentRsaKey(signingAlgorithm);
        return currentRsaKey != null ? new JsonWebKeyWrapper(currentRsaKey) : null;
    }

    public JsonWebKeyWrapper getCurrentEcKey(String curveName) {
        SdkJwkWrapper currentEcKey = this.jwkFacilitator.getCurrentEcKey(curveName);
        return currentEcKey != null ? new JsonWebKeyWrapper(currentEcKey) : null;
    }

    public JsonWebKeyWrapper getKeyById(String kid) {
        SdkJwkWrapper jwkWrapper = this.jwkFacilitator.getKeyById(kid);
        return jwkWrapper != null ? new JsonWebKeyWrapper(jwkWrapper) : null;
    }

    public JsonWebKeySet getSigningJsonWebKeySet() {
        List<JsonWebKey> keys = this.jwkFacilitator.getSigningJsonWebKeys();
        return new JsonWebKeySet(keys);
    }

    public JsonWebKeySet getDecryptionKeys() {
        List<JsonWebKey> keys = this.jwkFacilitator.getEncryptionKeys();
        return new JsonWebKeySet(keys);
    }

    public static final class JsonWebKeyWrapper {
        private final SdkJwkWrapper jwkWrapper;

        private JsonWebKeyWrapper(SdkJwkWrapper jwkWrapper) {
            this.jwkWrapper = jwkWrapper;
        }

        public PrivateKey getPrivateKey() {
            return this.jwkWrapper.getPrivateKey();
        }

        public String getKeyId() {
            return this.jwkWrapper.getKeyId();
        }

        public JsonWebKey getJWK() {
            return this.jwkWrapper.getJwk();
        }

        public String getPkCertID() {
            return this.jwkWrapper.getPkCertID();
        }
    }
}

