/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.access;

import com.pingidentity.sdk.internal.services.ArgPair;
import com.pingidentity.sdk.internal.services.ServiceFactory;
import com.pingidentity.sdk.internal.services.interfaces.SecretManagerService;
import com.pingidentity.sdk.secretmanager.SecretInfo;
import com.pingidentity.sdk.secretmanager.SecretManager;
import com.pingidentity.sdk.secretmanager.SecretManagerException;
import com.pingidentity.sdk.secretmanager.SecretReferenceUtil;
import java.util.Map;

public class SecretManagerAccessor {
    private SecretManagerAccessor() {
    }

    public static SecretInfo getSecretInfo(String secretReference, Map<String, Object> inParameters) throws SecretManagerException {
        if (!SecretReferenceUtil.isSecretReference(secretReference)) {
            throw new IllegalArgumentException("Invalid secret reference.");
        }
        String secretManagerId = SecretReferenceUtil.getSecretManagerId(secretReference);
        SecretManager secretManager = ServiceFactory.getSingleImpl(SecretManagerService.class, new ArgPair[0]).getSecretManager(SecretReferenceUtil.getSecretManagerId(secretReference));
        if (secretManager == null) {
            throw new IllegalArgumentException("No secret manager found with instance id: " + secretManagerId);
        }
        return secretManager.getSecretInfo(SecretReferenceUtil.getSecretId(secretReference), inParameters);
    }
}

