/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.adapter.support;

import com.pingidentity.sdk.internal.services.ArgPair;
import com.pingidentity.sdk.internal.services.ServiceFactory;
import com.pingidentity.sdk.internal.services.interfaces.TemplateService;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.sourceid.saml20.adapter.AuthnAdapterException;
import org.sourceid.saml20.adapter.idp.authn.IdpAuthenticationAdapter;
import org.sourceid.websso.servlet.adapter.Handler;
import org.sourceid.websso.servlet.adapter.HandlerRegistry;

public class LogoutHandler
implements Handler {
    private final IdpAuthenticationAdapter targetAdapter;
    private String redirectDestination;
    private String defaultContent = "<HTML>You've been logged out of the system.</HTML>";
    private String templateName;
    public static final String DEFAULT_CONTENT = "<HTML>You've been logged out of the system.</HTML>";

    public LogoutHandler(IdpAuthenticationAdapter adapter, String path) {
        this.targetAdapter = adapter;
        HandlerRegistry.registerHandler(path, this);
    }

    public String getRedirectDestination() {
        return this.redirectDestination;
    }

    public void setRedirectDestination(String redirectDestination) {
        this.redirectDestination = redirectDestination;
    }

    public String getDefaultContent() {
        return this.defaultContent;
    }

    public void setDefaultContent(String defaultContent) {
        this.defaultContent = defaultContent;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    @Override
    public void handle(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            this.targetAdapter.logoutAuthN(null, req, resp, null);
        }
        catch (AuthnAdapterException e) {
            throw new ServletException((Throwable)e);
        }
        if (!this.isBlank(this.redirectDestination)) {
            resp.sendRedirect(this.redirectDestination);
        } else if (!this.isBlank(this.templateName)) {
            ServiceFactory.getSingleImpl(TemplateService.class, new ArgPair[0]).render(req, resp, this.templateName, new HashMap<String, Object>());
        } else {
            PrintWriter writer = resp.getWriter();
            resp.setContentType("text/html");
            writer.write(this.defaultContent);
            writer.flush();
        }
    }

    private boolean isBlank(String s) {
        return s == null || "".equals(s);
    }
}

