/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.common.util;

import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;

public final class Base64URL {
    private Base64URL() {
        throw new UnsupportedOperationException("This class is not meant to be instantiated");
    }

    private static Base64 get() {
        return new Base64(-1, null, true);
    }

    public static String encodeToString(int i) {
        byte[] bytes = new byte[4];
        int j = 3;
        do {
            bytes[j] = (byte)(i & 0xFF);
        } while ((i >>>= 8) > 0 && --j >= 0);
        return Base64URL.get().encodeToString(bytes);
    }

    public static String encodeToString(byte[] bytes) {
        return Base64URL.get().encodeToString(bytes);
    }

    public static byte[] decode(String encodedString) {
        return Base64URL.get().decode(encodedString);
    }

    public static int decodeToInt(String encodedString) {
        if (encodedString.isEmpty()) {
            throw new NumberFormatException();
        }
        byte[] bytes = Base64URL.get().decode(encodedString);
        if (bytes.length > 4) {
            throw new NumberFormatException();
        }
        int i = 0;
        for (byte b : bytes) {
            i <<= 8;
            int temp = 0xFF & b;
            i |= temp;
        }
        return i;
    }

    public static String decodeToString(String encodedString, String charsetName) {
        byte[] bytes = Base64URL.get().decode(encodedString);
        return StringUtils.newString((byte[])bytes, (String)charsetName);
    }
}

