/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk;

import com.pingidentity.sdk.ConfigurablePlugin;
import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.GuiConfigDescriptorBuilder;
import com.pingidentity.sdk.SimpleGuiConfigDescriptorBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.adapter.gui.AdapterConfigurationGuiDescriptor;

public class PluginDescriptor {
    protected Log log = LogFactory.getLog(this.getClass());
    public static final String UNDEFINED = "UNDEFINED";
    protected String type;
    protected String pluginClassName;
    protected GuiConfigDescriptorBuilder guiConfigDescriptorBuilder;
    private Set<String> attributeContractSet = Collections.emptySet();
    private boolean supportsExtendedContract = true;
    protected String version = "UNDEFINED";
    private Map<String, Object> metadata = Collections.emptyMap();

    public PluginDescriptor() {
    }

    public PluginDescriptor(String type, ConfigurablePlugin plugin, GuiConfigDescriptor guiConfigDesc) {
        this(type, plugin, guiConfigDesc, UNDEFINED);
    }

    public PluginDescriptor(String type, ConfigurablePlugin plugin, GuiConfigDescriptor guiConfigDesc, String version) {
        this.init(type, plugin, version);
        GuiConfigDescriptor guiConfigDescriptor = guiConfigDesc == null ? new AdapterConfigurationGuiDescriptor() : guiConfigDesc;
        this.guiConfigDescriptorBuilder = new SimpleGuiConfigDescriptorBuilder(guiConfigDescriptor);
    }

    public PluginDescriptor(String type, ConfigurablePlugin plugin, GuiConfigDescriptorBuilder guiConfigDescBuilder) {
        this(type, plugin, guiConfigDescBuilder, UNDEFINED);
    }

    public PluginDescriptor(String type, ConfigurablePlugin plugin, GuiConfigDescriptorBuilder guiConfigDescBuilder, String version) {
        this.init(type, plugin, version);
        this.guiConfigDescriptorBuilder = guiConfigDescBuilder == null ? new SimpleGuiConfigDescriptorBuilder(new AdapterConfigurationGuiDescriptor()) : guiConfigDescBuilder;
    }

    private void init(String type, ConfigurablePlugin plugin, String version) {
        String simpleName = this.getClass().getSimpleName();
        if (StringUtils.isBlank((CharSequence)type)) {
            this.log.warn((Object)("Parameter 'type' cannot be null or empty when constructing an " + simpleName));
            type = UNDEFINED;
        }
        if (plugin == null) {
            this.log.warn((Object)("Parameter plugin cannot be null when constructing an " + simpleName));
            this.pluginClassName = UNDEFINED;
        } else {
            this.pluginClassName = plugin.getClass().getName();
        }
        this.type = type;
        this.version = version;
    }

    @Deprecated
    public void setAttributeContactSet(Set<String> attributeContactSet) {
        this.setAttributeContractSet(attributeContactSet);
    }

    public void setAttributeContractSet(Set<String> attributeContractSet) {
        if (attributeContractSet == null) {
            attributeContractSet = Collections.emptySet();
        }
        this.attributeContractSet = Collections.unmodifiableSet(attributeContractSet);
    }

    public String getType() {
        return this.type;
    }

    public Set<String> getAttributeContractSet() {
        return this.attributeContractSet;
    }

    public String getPluginClassName() {
        return this.pluginClassName;
    }

    @Deprecated
    public GuiConfigDescriptor getGuiConfigDescriptor() {
        return this.guiConfigDescriptorBuilder.buildNewGuiDescriptor();
    }

    public GuiConfigDescriptorBuilder getGuiConfigDescriptorBuilder() {
        return this.guiConfigDescriptorBuilder;
    }

    public int hashCode() {
        return this.pluginClassName.hashCode();
    }

    public boolean isSupportsExtendedContract() {
        return this.supportsExtendedContract;
    }

    public void setSupportsExtendedContract(boolean supportsExtendedContract) {
        this.supportsExtendedContract = supportsExtendedContract;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PluginDescriptor)) {
            return false;
        }
        PluginDescriptor authnAdapterDescriptor = (PluginDescriptor)obj;
        return this.pluginClassName.equals(authnAdapterDescriptor.pluginClassName);
    }

    public String getVersion() {
        return this.version;
    }

    public Map<String, Object> getMetadata() {
        return Collections.unmodifiableMap(this.metadata);
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = new HashMap<String, Object>(metadata);
    }
}

