/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.accessgrant;

import com.pingidentity.access.AuthorizationDetailProcessorAccessor;
import com.pingidentity.sdk.accessgrant.AccessGrant;
import com.pingidentity.sdk.accessgrant.AccessGrantAttributesHolder;
import com.pingidentity.sdk.accessgrant.AccessGrantCriteria;
import com.pingidentity.sdk.accessgrant.exception.AccessGrantManagementException;
import com.pingidentity.sdk.authorizationdetails.AuthorizationDetailContext;
import com.pingidentity.sdk.oauth20.Scope;
import java.util.Collection;
import java.util.stream.Collectors;

public interface AccessGrantManager {
    public AccessGrant getByRefreshToken(String var1) throws AccessGrantManagementException;

    public AccessGrant getByGuid(String var1) throws AccessGrantManagementException;

    public Collection<AccessGrant> getByUserKey(String var1) throws AccessGrantManagementException;

    public AccessGrant getByUserKeyScopeClientIdGrantTypeContext(String var1, Scope var2, String var3, String var4, String var5) throws AccessGrantManagementException;

    default public AccessGrant getByAccessGrantCriteria(AccessGrantCriteria accessGrantCriteria) throws AccessGrantManagementException {
        AccessGrant accessGrant = this.getByUserKeyScopeClientIdGrantTypeContext(accessGrantCriteria.getUserKey(), accessGrantCriteria.getScope(), accessGrantCriteria.getClientId(), accessGrantCriteria.getGrantType(), accessGrantCriteria.getContextQualifier());
        if (accessGrant == null) {
            return null;
        }
        if (accessGrantCriteria.getAuthorizationDetails() == null) {
            return accessGrant;
        }
        AuthorizationDetailContext context = new AuthorizationDetailContext(null, accessGrant.getClientId(), accessGrant.getScope());
        if (AuthorizationDetailProcessorAccessor.isEqualOrSubset(accessGrantCriteria.getAuthorizationDetails(), accessGrant.getAuthorizationDetails(), context)) {
            return accessGrant;
        }
        return null;
    }

    public Collection<AccessGrant> getByClientId(String var1) throws AccessGrantManagementException;

    default public Collection<AccessGrant> getByUserKeyClientIdGrantType(String userKey, String clientId, String grantType) throws AccessGrantManagementException {
        return this.getByUserKey(userKey).stream().filter(accessGrant -> accessGrant.getClientId().equals(clientId) && accessGrant.getGrantType().equals(grantType)).collect(Collectors.toList());
    }

    public void revokeGrant(String var1) throws AccessGrantManagementException;

    public void revokeGrant(String var1, String var2) throws AccessGrantManagementException;

    default public void deleteGrant(String accessGrantGuid) throws AccessGrantManagementException {
        this.revokeGrant(accessGrantGuid);
    }

    public void saveGrant(AccessGrant var1, AccessGrantAttributesHolder var2) throws AccessGrantManagementException;

    public void updateGrantAttributes(String var1, AccessGrantAttributesHolder var2) throws AccessGrantManagementException;

    public void updateRefreshToken(AccessGrant var1) throws AccessGrantManagementException;

    default public void updateExpiry(AccessGrant accessGrant) throws AccessGrantManagementException {
        throw new AccessGrantManagementException("Not supported.");
    }

    public boolean isDataSourceInUse(String var1);

    public void deleteExpiredGrants();

    public AccessGrantAttributesHolder getGrantAttributes(String var1) throws AccessGrantManagementException;
}

