/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.authorizationdetails;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.pingidentity.sdk.internal.json.deserializers.AuthorizationDetailDeserializer;
import com.pingidentity.sdk.internal.json.serializers.AuthorizationDetailSerializer;
import com.pingidentity.sdk.internal.services.ArgPair;
import com.pingidentity.sdk.internal.services.ServiceFactory;
import com.pingidentity.sdk.internal.services.interfaces.AuthorizationDetailsService;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@JsonSerialize(using=AuthorizationDetailSerializer.class)
@JsonDeserialize(using=AuthorizationDetailDeserializer.class)
public class AuthorizationDetail
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AuthorizationDetail.class);
    public static final String TYPE_FIELD_NAME = "type";
    public static final String COMMON_LOCATIONS_FIELD_NAME = "locations";
    public static final String COMMON_ACTIONS_FIELD_NAME = "actions";
    public static final String COMMON_DATATYPES_FIELD_NAME = "datatypes";
    public static final String COMMON_IDENTIFIER_FIELD_NAME = "identifier";
    public static final String COMMON_PRIVILEGES_FIELD_NAME = "privileges";
    private Map<String, Object> authorizationDetail;

    public AuthorizationDetail(Map<String, Object> authorizationDetail) {
        this.authorizationDetail = authorizationDetail;
    }

    public AuthorizationDetail(AuthorizationDetail authorizationDetail) {
        this.authorizationDetail = authorizationDetail.getDetail();
    }

    public String getType() {
        return (String)this.authorizationDetail.get(TYPE_FIELD_NAME);
    }

    public String[] getLocations() {
        List locations = (List)this.authorizationDetail.get(COMMON_LOCATIONS_FIELD_NAME);
        return locations == null ? null : (String[])locations.toArray(String[]::new);
    }

    public String[] getActions() {
        List actions = (List)this.authorizationDetail.get(COMMON_ACTIONS_FIELD_NAME);
        return actions == null ? null : (String[])actions.toArray(String[]::new);
    }

    public String[] getDataTypes() {
        List dataTypes = (List)this.authorizationDetail.get(COMMON_DATATYPES_FIELD_NAME);
        return dataTypes == null ? null : (String[])dataTypes.toArray(String[]::new);
    }

    public String getIdentifier() {
        return (String)this.authorizationDetail.get(COMMON_IDENTIFIER_FIELD_NAME);
    }

    public String[] getPrivileges() {
        List privileges = (List)this.authorizationDetail.get(COMMON_PRIVILEGES_FIELD_NAME);
        return privileges == null ? null : (String[])privileges.toArray(String[]::new);
    }

    public Map<String, Object> getDetail() {
        try {
            return ServiceFactory.getSingleImpl(AuthorizationDetailsService.class, new ArgPair[0]).getDetail(this.authorizationDetail);
        }
        catch (JsonProcessingException e) {
            log.error((Object)"unable to create copy of the authorization detail, returning null", (Throwable)e);
            return null;
        }
    }

    public void setDetail(Map<String, Object> authorizationDetail) {
        this.authorizationDetail = authorizationDetail;
    }
}

