/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.authorizationdetails;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.pingidentity.sdk.authorizationdetails.AuthorizationDetail;
import com.pingidentity.sdk.internal.services.ArgPair;
import com.pingidentity.sdk.internal.services.ServiceFactory;
import com.pingidentity.sdk.internal.services.interfaces.AuthorizationDetailsService;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.adapter.attribute.AttributeValue;

public class AuthorizationDetails
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(AuthorizationDetails.class);
    private final List<AuthorizationDetail> authorizationDetails;

    public AuthorizationDetails() {
        this.authorizationDetails = null;
    }

    public AuthorizationDetails(AuthorizationDetails authorizationDetails) {
        this.authorizationDetails = authorizationDetails.getDetails().stream().map(AuthorizationDetail::new).collect(Collectors.toList());
    }

    public AuthorizationDetails(AuthorizationDetail[] authorizationDetails) {
        this.authorizationDetails = authorizationDetails == null ? null : Arrays.stream(authorizationDetails).collect(Collectors.toList());
    }

    public AuthorizationDetails(String authorizationDetails) throws IOException {
        if (StringUtils.isBlank((CharSequence)authorizationDetails)) {
            this.authorizationDetails = null;
        } else {
            try {
                this.authorizationDetails = ServiceFactory.getSingleImpl(AuthorizationDetailsService.class, new ArgPair[0]).getAuthorizationDetails(authorizationDetails);
            }
            catch (JsonProcessingException e) {
                log.debug((Object)e);
                throw new IOException("The requested authorization detail is invalid, unknown, malformed.", e);
            }
        }
    }

    public List<AuthorizationDetail> getDetails() {
        return this.authorizationDetails;
    }

    public String toJson() {
        return ServiceFactory.getSingleImpl(AuthorizationDetailsService.class, new ArgPair[0]).toJson(this);
    }

    public AttributeValue toAttributeValue() {
        if (this.authorizationDetails == null) {
            return null;
        }
        try {
            return ServiceFactory.getSingleImpl(AuthorizationDetailsService.class, new ArgPair[0]).toAttributeValue(this);
        }
        catch (JsonProcessingException e) {
            log.debug((Object)("error deserializing authorization detail JSON: " + this.toJson()), (Throwable)e);
            return null;
        }
    }
}

