/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.locale;

import com.pingidentity.sdk.internal.services.ArgPair;
import com.pingidentity.sdk.internal.services.ServiceFactory;
import com.pingidentity.sdk.internal.services.interfaces.LocaleService;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LanguagePackMessages {
    private final Log log = LogFactory.getLog(LanguagePackMessages.class);
    private final ResourceBundle resourceBundle;
    public static final String LANGUAGE_PACK_DIR_NAME = "language-packs";

    public LanguagePackMessages(String resourceBundleBaseName, Locale locale) {
        ResourceBundle.Control control = ServiceFactory.getSingleImpl(LocaleService.class, new ArgPair[0]).getPropertyResourceBundleControl();
        String baseName = "language-packs." + resourceBundleBaseName;
        this.resourceBundle = ResourceBundle.getBundle(baseName, locale, control);
    }

    public String getMessage(String key) {
        return this.getMessageWithSubstitutions(key, null);
    }

    public String getMessage(String keyPrefix, String key) {
        return this.getMessageWithSubstitutions(keyPrefix + key, null);
    }

    public String getMessage(String keyPrefix, String key, String ... substitutions) {
        return this.getMessageWithSubstitutions(keyPrefix + key, substitutions);
    }

    public String getMessage(String key, String[] substitutions) {
        return this.getMessageWithSubstitutions(key, substitutions);
    }

    public String getMessageWithDefault(String keyPrefix, String key, String defaultMessage) {
        String message = this.getMessageWithDefault(keyPrefix, key, defaultMessage, null);
        if (message.equals(keyPrefix + key)) {
            return defaultMessage;
        }
        return message;
    }

    public String getMessageWithDefault(String key, String defaultMessage) {
        String message = this.getMessageWithDefault(key, defaultMessage, (String[])null);
        if (message.equals(key)) {
            return defaultMessage;
        }
        return message;
    }

    public String getMessageWithDefault(String keyPrefix, String key, String defaultMessage, String[] substitutions) {
        String message = this.getMessage(keyPrefix, key, substitutions);
        if (message.equals(keyPrefix + key)) {
            return defaultMessage;
        }
        return message;
    }

    public String getMessageWithDefault(String key, String defaultMessage, String[] substitutions) {
        String message = this.getMessage(key, substitutions);
        if (message.equals(key)) {
            return defaultMessage;
        }
        return message;
    }

    private String getMessageWithSubstitutions(String key, String ... substitutions) {
        if (key == null) {
            return null;
        }
        String message = this.getStringFromResourceBundle(key);
        if (substitutions != null && substitutions.length > 0) {
            for (int i = 0; i < substitutions.length; ++i) {
                substitutions[i] = this.getStringFromResourceBundle(substitutions[i]);
            }
            message = message.replace("'", "''");
            message = MessageFormat.format(message, substitutions);
        }
        return message;
    }

    private String getStringFromResourceBundle(String key) {
        String message;
        block2: {
            message = key;
            try {
                message = this.resourceBundle.getString(key);
            }
            catch (Exception ex) {
                if (!this.log.isDebugEnabled()) break block2;
                this.log.debug((Object)("Unable to get message for key: " + key));
            }
        }
        return message.trim();
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }
}

