/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.logging;

import com.pingidentity.common.util.Base64URL;
import com.pingidentity.sdk.internal.services.ArgPair;
import com.pingidentity.sdk.internal.services.ServiceFactory;
import com.pingidentity.sdk.internal.services.interfaces.AuditLoggerService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.common.HashAlgorithm;
import org.sourceid.common.HashUtil;

public final class LoggingUtil {
    public static final String SUCCESS = "success";
    public static final String FAILURE = "failure";
    private static final Log log = LogFactory.getLog(LoggingUtil.class);

    private LoggingUtil() {
        throw new UnsupportedOperationException("This class is not meant to be instantiated");
    }

    private static AuditLoggerService getService() {
        return ServiceFactory.getSingleImpl(AuditLoggerService.class, new ArgPair[0]);
    }

    public static void init() {
        LoggingUtil.getService().init();
    }

    public static void log(String msg) {
        AuditLoggerService service = LoggingUtil.getService();
        if (service.isDescriptionBlank()) {
            service.setDescription(msg);
        }
        service.updateResponseTime();
        service.log(log, msg);
    }

    public static void cleanup() {
        LoggingUtil.getService().cleanup();
    }

    public static void setStatus(String status) {
        LoggingUtil.getService().setStatus(status);
    }

    public static void setUserName(String username) {
        LoggingUtil.getService().setUserName(username);
    }

    public static void setPartnerId(String partnerId) {
        LoggingUtil.getService().setPartnerId(partnerId);
    }

    public static void setInMessageContext(String inMessageContext) {
        LoggingUtil.getService().setInMessageContext(inMessageContext);
    }

    public static void setOutMessageContext(String outMessageContext) {
        LoggingUtil.getService().setOutMessageContext(outMessageContext);
    }

    public static void setHost(String host) {
        LoggingUtil.getService().setHost(host);
    }

    public static void setRemoteAddress(String remoteAddress) {
        LoggingUtil.getService().setRemoteAddress(remoteAddress);
    }

    public static void setProtocol(String protocol) {
        LoggingUtil.getService().setProtocol(protocol);
    }

    public static void setRequestStartTime(Long startTime) {
        LoggingUtil.getService().setRequestStartTime(startTime);
    }

    public static void updateResponseTime() {
        LoggingUtil.getService().updateResponseTime();
    }

    public static void setEvent(String event) {
        LoggingUtil.getService().setEvent(event);
    }

    public static String getEvent() {
        return LoggingUtil.getService().getEvent();
    }

    public static void setDescription(String description) {
        LoggingUtil.getService().setDescription(description);
    }

    public static void setRole(String role) {
        LoggingUtil.getService().setRole(role);
    }

    public static void setAccessTokenJti(String jti) {
        LoggingUtil.getService().setAccessTokenJti(jti);
    }

    public static void setRequestJti(String jti) {
        LoggingUtil.getService().setRequestJti(jti);
    }

    public static String calculateHashForLogging(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        byte[] bytes = HashUtil.hashToBytes(value, HashAlgorithm.SHA1);
        return Base64URL.encodeToString(bytes);
    }
}

