/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.oauth20;

import com.pingidentity.sdk.authorizationdetails.AuthorizationDetails;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.sourceid.saml20.adapter.attribute.AttributeValue;

public class AccessToken
implements Serializable {
    private volatile long expiresAt;
    private Map<String, AttributeValue> attributes;
    private String scope;
    private String clientId;
    private String accessGrantGuid;
    private List<String> audience;
    private String issuer;
    private String tokenIdentifier;
    private AuthorizationDetails authorizationDetails;

    public AccessToken(long expiresAt, Map<String, AttributeValue> attributes, String scopeString, String clientId, String accessGrantGuid) {
        this.expiresAt = expiresAt;
        this.attributes = attributes;
        this.scope = scopeString;
        this.clientId = clientId;
        this.accessGrantGuid = accessGrantGuid;
    }

    public AccessToken(long expiresAt, Map<String, AttributeValue> attributes, String scopeString, String clientId, String accessGrantGuid, AuthorizationDetails authorizationDetails) {
        this.expiresAt = expiresAt;
        this.attributes = attributes;
        this.scope = scopeString;
        this.clientId = clientId;
        this.accessGrantGuid = accessGrantGuid;
        this.authorizationDetails = authorizationDetails;
    }

    public long getExpiresAt() {
        return this.expiresAt;
    }

    public void setExpiresAt(long exp) {
        this.expiresAt = exp;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() > this.getExpiresAt();
    }

    public Map<String, AttributeValue> getAttributes() {
        return Collections.unmodifiableMap(this.attributes);
    }

    public String getScope() {
        return this.scope;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getAccessGrantGuid() {
        return this.accessGrantGuid;
    }

    public boolean hasAccessGrantGuid() {
        return this.accessGrantGuid != null;
    }

    public List<String> getAudience() {
        return this.audience;
    }

    public void setAudience(List<String> audience) {
        this.audience = audience;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public String getTokenIdentifier() {
        return this.tokenIdentifier;
    }

    public void setTokenIdentifier(String tokenIdentifier) {
        this.tokenIdentifier = tokenIdentifier;
    }

    public AuthorizationDetails getAuthorizationDetails() {
        return this.authorizationDetails;
    }
}

