/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.oauth20;

import com.pingidentity.sdk.internal.services.ArgPair;
import com.pingidentity.sdk.internal.services.ServiceFactory;
import com.pingidentity.sdk.internal.services.interfaces.ScopeService;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.sourceid.common.SpaceDelimitedStringUtil;

public class Scope
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String scopeStr;
    private final Set<String> scopeSet;
    private volatile Scope expandedScope;

    public static Scope getScope(String scopeStr) {
        return ServiceFactory.getSingleImpl(ScopeService.class, new ArgPair[0]).getScope(scopeStr);
    }

    public Scope(String scopeStr) {
        this.scopeSet = Scope.decode(scopeStr);
        this.scopeStr = Scope.encode(this.scopeSet);
    }

    public Scope(Set<String> scopeSet) {
        this.scopeSet = Objects.requireNonNullElse(scopeSet, Collections.emptySet());
        this.scopeStr = Scope.encode(this.scopeSet);
    }

    public Scope(String ... scopeArray) {
        this(new LinkedHashSet<String>(Arrays.asList(Objects.requireNonNullElse(scopeArray, new String[0]))));
    }

    public String getScopeStr() {
        return this.scopeStr;
    }

    public String toString() {
        return this.getScopeStr();
    }

    public Set<String> getScopeSet() {
        return this.scopeSet;
    }

    public boolean hasScope(String individualScopeValue) {
        ScopeService scopeService = ServiceFactory.getSingleImpl(ScopeService.class, new ArgPair[0]);
        return this.expanded().scopeSet.contains(individualScopeValue) || this.expanded().scopeSet.stream().anyMatch(scope -> scopeService.isValidDynamicPair((String)scope, individualScopeValue));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Scope) {
            Scope thatScope = (Scope)obj;
            return thatScope.scopeSet.size() == this.scopeSet.size() && this.scopeSet.containsAll(thatScope.scopeSet);
        }
        return false;
    }

    public int hashCode() {
        return 123 + (this.scopeSet == null ? 0 : this.scopeSet.hashCode());
    }

    public boolean isEqualOrLesserThan(Scope scope) {
        Scope thisExpandedScope = this.expanded();
        Scope thatExpandedScope = scope.expanded();
        HashSet<String> thisScopeSet = new HashSet<String>(thisExpandedScope.scopeSet);
        HashSet<String> thatScopeSet = new HashSet<String>(thatExpandedScope.scopeSet);
        thisScopeSet.removeAll(thatExpandedScope.scopeSet);
        thatScopeSet.removeAll(thisExpandedScope.scopeSet);
        if (thisScopeSet.isEmpty()) {
            return true;
        }
        Set<String> allDynamicScopes = this.getDynamicScopes();
        if (allDynamicScopes.containsAll(thisScopeSet) && allDynamicScopes.containsAll(thatScopeSet)) {
            return false;
        }
        thatScopeSet.retainAll(allDynamicScopes);
        return ServiceFactory.getSingleImpl(ScopeService.class, new ArgPair[0]).containsAllDynamicScopes(thatScopeSet, thisScopeSet);
    }

    public boolean hasAllScopes(Scope scope) {
        Scope thisExpandedScope = this.expanded();
        Scope thatExpandedScope = scope.expanded();
        HashSet<String> thisScopeSet = new HashSet<String>(thisExpandedScope.scopeSet);
        HashSet<String> thatScopeSet = new HashSet<String>(thatExpandedScope.scopeSet);
        thisScopeSet.removeAll(thatExpandedScope.scopeSet);
        thatScopeSet.removeAll(thisExpandedScope.scopeSet);
        if (thatScopeSet.isEmpty()) {
            return true;
        }
        Set<String> allDynamicScopes = this.getDynamicScopes();
        if (allDynamicScopes.containsAll(thisScopeSet) && allDynamicScopes.containsAll(thatScopeSet)) {
            return false;
        }
        thatScopeSet.retainAll(allDynamicScopes);
        ScopeService scopeService = ServiceFactory.getSingleImpl(ScopeService.class, new ArgPair[0]);
        Predicate<String> matchDynamicScopes = rawDynamicScope -> thisScopeSet.stream().anyMatch(concreteScope -> scopeService.isValidDynamicPair((String)rawDynamicScope, (String)concreteScope));
        return !thatScopeSet.isEmpty() && thatScopeSet.stream().allMatch(matchDynamicScopes);
    }

    private Set<String> getDynamicScopes() {
        ScopeService scopeService = ServiceFactory.getSingleImpl(ScopeService.class, new ArgPair[0]);
        return Stream.concat(scopeService.getDynamicCommonScopes().stream(), scopeService.getDynamicExclusiveScopes().stream()).collect(Collectors.toSet());
    }

    public Set<String> scopesNotIn(Scope scope) {
        return this.scopeSet.stream().filter(individualScope -> !scope.hasScope((String)individualScope)).collect(Collectors.toSet());
    }

    public Scope expanded() {
        if (this.expandedScope == null) {
            HashSet<String> expanded = new HashSet<String>();
            ScopeService scopeService = ServiceFactory.getSingleImpl(ScopeService.class, new ArgPair[0]);
            HashMap<String, Set<String>> groupMappingsFromScopeManager = new HashMap<String, Set<String>>(scopeService.getScopeGroupMappings());
            groupMappingsFromScopeManager.putAll(scopeService.getExclusiveScopeGroupMappings());
            for (String scopeOrGroup : this.scopeSet) {
                if (groupMappingsFromScopeManager.containsKey(scopeOrGroup)) {
                    expanded.addAll((Collection)groupMappingsFromScopeManager.get(scopeOrGroup));
                    continue;
                }
                expanded.add(scopeOrGroup);
            }
            this.expandedScope = new Scope(expanded);
        }
        return this.expandedScope;
    }

    public static Set<String> decode(String scope) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        SpaceDelimitedStringUtil.fromString(scope, set);
        return set;
    }

    public static String encode(Set<String> scopes) {
        return SpaceDelimitedStringUtil.toString(scopes);
    }
}

