/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sdk.password;

import com.pingidentity.sdk.internal.services.ArgPair;
import com.pingidentity.sdk.internal.services.ServiceFactory;
import com.pingidentity.sdk.internal.services.interfaces.LocaleService;
import com.pingidentity.sdk.locale.LanguagePackMessages;
import com.pingidentity.sdk.locale.Message;
import com.pingidentity.sdk.password.PasswordCredentialValidatorAuthnException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PasswordPolicyRequirementValidationException
extends PasswordCredentialValidatorAuthnException {
    private static final Log log = LogFactory.getLog(PasswordPolicyRequirementValidationException.class);
    private final List<Message> requirementsMet;
    private final List<Message> requirementsNotMet;
    private final LocaleService localeService;

    public PasswordPolicyRequirementValidationException(String message, List<Message> requirementsMet, List<Message> requirementsNotMet) {
        super(true, message);
        this.requirementsMet = new ArrayList<Message>(requirementsMet);
        this.requirementsNotMet = new ArrayList<Message>(requirementsNotMet);
        this.localeService = ServiceFactory.getSingleImpl(LocaleService.class, new ArgPair[0]);
    }

    public List<String> getRequirementsMet(Locale locale) {
        ArrayList<String> reqMetString = new ArrayList<String>(this.requirementsMet.size());
        LanguagePackMessages languagePackMessages = this.localeService.getLanguagePackMessagesForHtmlTemplates(locale);
        PasswordPolicyRequirementValidationException.populateMsgListFromReqMessages(reqMetString, languagePackMessages, this.requirementsMet);
        return reqMetString;
    }

    public List<String> getRequirementsNotMet(Locale locale) {
        ArrayList<String> reqMetString = new ArrayList<String>(this.requirementsNotMet.size());
        LanguagePackMessages languagePackMessages = this.localeService.getLanguagePackMessagesForHtmlTemplates(locale);
        PasswordPolicyRequirementValidationException.populateMsgListFromReqMessages(reqMetString, languagePackMessages, this.requirementsNotMet);
        return reqMetString;
    }

    static void populateMsgListFromReqMessages(List<String> stringList, LanguagePackMessages languagePackMessages, List<Message> messageList) {
        TreeSet<String> stringSet = new TreeSet<String>();
        for (Message message : messageList) {
            String topLvlMsg = languagePackMessages.getMessage(message.getMessageKey(), message.getParams());
            if (message.getMessageKey().equals(topLvlMsg)) {
                stringSet.add(message.getMessageKey());
                log.debug((Object)("Could not find localized message for key '" + topLvlMsg + "'."));
                continue;
            }
            StringBuilder requirementMsg = new StringBuilder(topLvlMsg);
            for (Message nestedMessage : message.getNestedMessages()) {
                String msgToAppend = languagePackMessages.getMessage(nestedMessage.getMessageKey(), nestedMessage.getParams());
                if (!StringUtils.isNotEmpty((CharSequence)msgToAppend)) continue;
                requirementMsg.append(" ").append(msgToAppend);
            }
            stringSet.add(requirementMsg.toString());
        }
        if (stringSet.size() > 0) {
            stringList.addAll(stringSet);
        }
    }
}

