/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.oauth20.domain;

import com.pingidentity.sdk.oauth20.registration.ClientAuthType;

public enum ClientAuthenticationType {
    NONE,
    SECRET,
    CLIENT_CERT,
    PRIVATE_KEY_JWT,
    CLIENT_SECRET_JWT;


    public static String toClientAuthnType(ClientAuthenticationType clientAuthenticationType) {
        switch (clientAuthenticationType) {
            case NONE: {
                return ClientAuthType.none.name();
            }
            case SECRET: {
                return ClientAuthType.client_secret_basic.name();
            }
            case CLIENT_CERT: {
                return ClientAuthType.tls_client_auth.name();
            }
            case PRIVATE_KEY_JWT: {
                return ClientAuthType.private_key_jwt.name();
            }
            case CLIENT_SECRET_JWT: {
                return ClientAuthType.client_secret_jwt.name();
            }
        }
        return null;
    }
}

