/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.adapter.conf;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.sourceid.saml20.adapter.conf.Field;

public abstract class FieldList
implements Serializable {
    private static final long serialVersionUID = 20050515L;
    private LinkedHashMap<String, Field> fieldsMap = new LinkedHashMap();

    protected FieldList() {
    }

    protected FieldList(List<Field> fields) {
        this();
        for (Field f : fields) {
            this.fieldsMap.put(f.getName(), f);
        }
    }

    public List<Field> getFields() {
        ArrayList<Field> fieldsList = new ArrayList<Field>();
        for (Map.Entry<String, Field> entry : this.fieldsMap.entrySet()) {
            fieldsList.add(entry.getValue());
        }
        return fieldsList;
    }

    public Map<String, Field> getReadOnlyFieldMap() {
        return Collections.unmodifiableMap(this.fieldsMap);
    }

    public String getFieldValue(String name) {
        Field field = this.getField(name);
        return field != null ? field.getValue() : null;
    }

    public int getIntFieldValue(String name) {
        Field field = this.getField(name);
        return field != null ? field.getValueAsInt() : 0;
    }

    public long getLongFieldValue(String name) {
        Field field = this.getField(name);
        return field != null ? field.getValueAsLong() : 0L;
    }

    public float getFloatFieldValue(String name) {
        Field field = this.getField(name);
        return field != null ? field.getValueAsFloat() : 0.0f;
    }

    public double getDoubleFieldValue(String name) {
        Field field = this.getField(name);
        return field != null ? field.getValueAsDouble() : 0.0;
    }

    public boolean getBooleanFieldValue(String name) {
        Field field = this.getField(name);
        return field != null && field.getValueAsBoolean();
    }

    public boolean getBooleanFieldValue(String name, boolean defaultValue) {
        Field field = this.getField(name);
        if (field != null) {
            return field.getValueAsBoolean();
        }
        return defaultValue;
    }

    public byte[] getFileFieldValueAsByteArray(String name) {
        Field field = this.getField(name);
        return field != null ? field.getFileValueAsByteArray() : null;
    }

    public String getFileFiledValueAsString(String name) {
        Field field = this.getField(name);
        return field != null ? field.getFileValueAsString() : null;
    }

    public Field getField(String name) {
        return this.fieldsMap.get(name);
    }

    public boolean isEmpty() {
        return this.fieldsMap.isEmpty();
    }

    public String toString() {
        return "Fields: " + this.getFields().toString();
    }

    public void addField(Field field) {
        this.fieldsMap.put(field.getName(), field);
    }
}

