/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.adapter.gui;

import java.util.Collections;
import java.util.List;
import org.sourceid.saml20.adapter.gui.FilterableSelectionFieldDescriptor;

public class ConnectionSelectionFieldDescriptor
extends FilterableSelectionFieldDescriptor {
    private ConnectionType connectionType;
    private final List<FilterableSelectionFieldDescriptor.SearchableTypeConfig> connectionSearchableConfigList;

    public ConnectionSelectionFieldDescriptor(String name, String description, ConnectionType connectionType) {
        super(name, description);
        this.connectionType = connectionType;
        this.connectionSearchableConfigList = Collections.singletonList(this.connectionType.getSearchableTypeConfig());
    }

    public ConnectionType getConnectionType() {
        return this.connectionType;
    }

    @Override
    public List<FilterableSelectionFieldDescriptor.SearchableTypeConfig> getSearchableTypes() {
        return this.connectionSearchableConfigList;
    }

    public static enum ConnectionType {
        IDP_CONNECTION{

            @Override
            protected FilterableSelectionFieldDescriptor.SearchableTypeConfig getSearchableTypeConfig() {
                return FilterableSelectionFieldDescriptor.SearchableTypeConfig.IDP_CONNECTION;
            }
        }
        ,
        SP_CONNECTION{

            @Override
            protected FilterableSelectionFieldDescriptor.SearchableTypeConfig getSearchableTypeConfig() {
                return FilterableSelectionFieldDescriptor.SearchableTypeConfig.SP_CONNECTION;
            }
        };


        protected abstract FilterableSelectionFieldDescriptor.SearchableTypeConfig getSearchableTypeConfig();
    }
}

