/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.adapter.gui;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.sourceid.saml20.adapter.gui.FilterableSelectionFieldDescriptor;

public class OAuthScopeSelectionFieldDescriptor
extends FilterableSelectionFieldDescriptor {
    public static final String COMMON_SCOPE_SUFFIX = " - (Common Scope)";
    public static final String COMMON_SCOPE_GROUP_SUFFIX = " - (Common Scope Group)";
    public static final String EXCLUSIVE_SCOPE_SUFFIX = " - (Exclusive Scope)";
    public static final String EXCLUSIVE_SCOPE_GROUP_SUFFIX = " - (Exclusive Scope Group)";

    public OAuthScopeSelectionFieldDescriptor(String name, String description) {
        super(name, description);
    }

    @Override
    public List<FilterableSelectionFieldDescriptor.SearchableTypeConfig> getSearchableTypes() {
        return List.of(FilterableSelectionFieldDescriptor.SearchableTypeConfig.OAUTH_COMMON_SCOPE, FilterableSelectionFieldDescriptor.SearchableTypeConfig.OAUTH_COMMON_SCOPE_GROUP, FilterableSelectionFieldDescriptor.SearchableTypeConfig.OAUTH_EXCLUSIVE_SCOPE, FilterableSelectionFieldDescriptor.SearchableTypeConfig.OAUTH_EXCLUSIVE_SCOPE_GROUP);
    }

    @Override
    public String getSelectedDisplayName(String valueForStorage) {
        return this.storageKeyToSourceName(valueForStorage);
    }

    private String storageKeyToSourceName(String storageKey) {
        if (storageKey == null) {
            return null;
        }
        String prefix = StringUtils.substringBefore((String)storageKey, (String)"|");
        String id = StringUtils.substringAfter((String)storageKey, (String)"|");
        if (prefix.equals(FilterableSelectionFieldDescriptor.SearchableTypeConfig.OAUTH_COMMON_SCOPE.getStorageKeyPrefix())) {
            return id + COMMON_SCOPE_SUFFIX;
        }
        if (prefix.equals(FilterableSelectionFieldDescriptor.SearchableTypeConfig.OAUTH_COMMON_SCOPE_GROUP.getStorageKeyPrefix())) {
            return id + COMMON_SCOPE_GROUP_SUFFIX;
        }
        if (prefix.equals(FilterableSelectionFieldDescriptor.SearchableTypeConfig.OAUTH_EXCLUSIVE_SCOPE.getStorageKeyPrefix())) {
            return id + EXCLUSIVE_SCOPE_SUFFIX;
        }
        if (prefix.equals(FilterableSelectionFieldDescriptor.SearchableTypeConfig.OAUTH_EXCLUSIVE_SCOPE_GROUP.getStorageKeyPrefix())) {
            return id + EXCLUSIVE_SCOPE_GROUP_SUFFIX;
        }
        return id;
    }

    public static String storageKeyToScopeName(String storageKey) {
        if (storageKey == null) {
            return null;
        }
        return StringUtils.substringAfter((String)storageKey, (String)"|");
    }
}

