/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.adapter.gui.validation.impl;

import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;

public class DoubleValidator
implements FieldValidator {
    private double lowerBound = -1.7976931348623157E308;
    private double upperBound = Double.MAX_VALUE;

    public DoubleValidator() {
    }

    public DoubleValidator(double lowerBound, double upperBound) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    @Override
    public void validate(Field field) throws ValidationException {
        try {
            Double tmp = Double.parseDouble(field.getValue());
            if (tmp < this.lowerBound || tmp > this.upperBound) {
                throw new ValidationException("'" + field.getLabel() + "' is out of range, please enter a value between " + this.lowerBound + " and " + this.upperBound + ".");
            }
        }
        catch (NumberFormatException ex) {
            throw new ValidationException("'" + field.getLabel() + "' is not a valid Double: '" + field.getValue() + "'.");
        }
    }
}

