/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.adapter.gui.validation.impl;

import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;

public class FloatValidator
implements FieldValidator {
    private float lowerBound = -3.4028235E38f;
    private float upperBound = Float.MAX_VALUE;

    public FloatValidator() {
    }

    public FloatValidator(float lowerBound, float upperBound) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    @Override
    public void validate(Field field) throws ValidationException {
        try {
            Float tmp = Float.valueOf(Float.parseFloat(field.getValue()));
            if (tmp.floatValue() < this.lowerBound || tmp.floatValue() > this.upperBound) {
                throw new ValidationException("'" + field.getLabel() + "' is out of range, please enter a value between " + this.lowerBound + " and " + this.upperBound + ".");
            }
        }
        catch (NumberFormatException ex) {
            throw new ValidationException("'" + field.getLabel() + "' is not a valid Float: '" + field.getValue() + "'.");
        }
    }
}

