/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.adapter.gui.validation.impl;

import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;

public class HttpURLValidator
implements FieldValidator {
    @Override
    public void validate(Field field) throws ValidationException {
        try {
            URL url = new URL(field.getValue());
            String protocol = url.getProtocol();
            if (!"http".equalsIgnoreCase(protocol) && !"https".equalsIgnoreCase(protocol)) {
                throw new ValidationException("'" + field.getLabel() + "' is not a valid HTTP or HTTPS URL. Protocol: '" + protocol + "'.");
            }
            if (StringUtils.isBlank((CharSequence)url.getHost())) {
                String msg = "'" + field.getLabel() + "' is not a valid URL. Please include a host name or IP address.";
                throw new ValidationException(msg);
            }
        }
        catch (MalformedURLException ex) {
            throw new ValidationException("'" + field.getName() + "' is not a valid HTTP or HTTPS URL: " + ex.getMessage() + ".");
        }
    }
}

