/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.adapter.gui.validation.impl;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jose4j.jwk.JsonWebKeySet;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;

public class JwksValidator
implements FieldValidator {
    @Override
    public void validate(Field field) throws ValidationException {
        String value = field.getValue();
        if (StringUtils.isNotBlank((CharSequence)value)) {
            try {
                JsonWebKeySet jsonWebKeySet = new JsonWebKeySet(value);
                List keys = jsonWebKeySet.getJsonWebKeys();
                if (keys == null || keys.isEmpty()) {
                    throw new ValidationException("At least one JSON Web Key must be defined in a JWKS.");
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ValidationException("Invalid JWKS");
            }
        }
    }
}

