/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.adapter.gui.validation.impl;

import java.text.MessageFormat;
import java.util.regex.Pattern;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;

public class RegExValidator
implements FieldValidator {
    public static final String DEFAULT_MESSAGE_FORMAT = "''{0}'' is not formatted correctly.";
    private Pattern pattern;
    private MessageFormat messageFormat = new MessageFormat("''{0}'' is not formatted correctly.");

    public RegExValidator(Pattern pattern) {
        this.pattern = pattern;
    }

    public RegExValidator(String regex) {
        this(Pattern.compile(regex));
    }

    public RegExValidator(String regex, int flags) {
        this(Pattern.compile(regex, flags));
    }

    public void setMessageFormat(String messagePattern) {
        this.messageFormat = new MessageFormat(messagePattern);
    }

    @Override
    public void validate(Field field) throws ValidationException {
        if (field.getValue() == null || !this.pattern.matcher(field.getValue()).matches()) {
            throw new ValidationException(this.messageFormat.format(new Object[]{field.getLabel(), field.getValue()}));
        }
    }
}

