/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.adapter.gui.validation.impl;

import com.pingidentity.sdk.internal.services.ArgPair;
import com.pingidentity.sdk.internal.services.ServiceFactory;
import com.pingidentity.sdk.internal.services.interfaces.ValidationService;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.gui.validation.FieldValidator;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;

public class URLValidator
implements FieldValidator {
    private static final long serialVersionUID = 1L;
    private boolean allowAllProtocols = false;
    private final transient ValidationService validationService;

    public URLValidator() {
        this.validationService = ServiceFactory.getSingleImpl(ValidationService.class, new ArgPair[0]);
    }

    public URLValidator(boolean allowAllProtocols) {
        this.allowAllProtocols = allowAllProtocols;
        this.validationService = ServiceFactory.getSingleImpl(ValidationService.class, new ArgPair[0]);
    }

    @Override
    public void validate(Field field) throws ValidationException {
        if (this.allowAllProtocols) {
            if (!this.validationService.isValidUrl(field.getValue())) {
                throw new ValidationException("'" + field.getLabel() + "' is not a valid URL.");
            }
        } else {
            try {
                URL url = new URL(field.getValue());
                String host = url.getHost();
                if (StringUtils.isBlank((CharSequence)host)) {
                    String msg = "'" + field.getLabel() + "' is not a valid URL. Please include a host name or IP address.";
                    throw new ValidationException(msg);
                }
            }
            catch (MalformedURLException ex) {
                throw new ValidationException("'" + field.getLabel() + "' is not a valid URL: " + ex.getMessage());
            }
        }
    }
}

