/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.adapter.sp.authn;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.xmlbinding.assertion.AssertionType;
import org.sourceid.util.log.AttributeMap;

public class SsoContext
implements Serializable {
    private Map<String, AttributeValue> subjectAttributes;
    private AssertionType ssoAssertion;
    private List<AssertionType> otherValidAssertions;
    private String idpPartnerEntityId;
    private String targetResourceUrl;
    private String authnCtx;
    private Date authenticationInstant;

    public SsoContext(AttributeMap subjectAttributes, AssertionType ssoAssertion, List<AssertionType> otherValidAssertions, String idpPartnerEntityId, String targetResourceUrl) {
        this.subjectAttributes = subjectAttributes;
        this.ssoAssertion = ssoAssertion;
        this.otherValidAssertions = otherValidAssertions;
        this.idpPartnerEntityId = idpPartnerEntityId;
        this.targetResourceUrl = targetResourceUrl;
    }

    private SsoContext(AttributeMap subjectAttributes, AssertionType ssoAssertion, List<AssertionType> otherValidAssertions, String idpPartnerEntityId, String targetResourceUrl, String authnCtx) {
        this(subjectAttributes, ssoAssertion, otherValidAssertions, idpPartnerEntityId, targetResourceUrl);
        this.authnCtx = authnCtx;
    }

    public SsoContext(AttributeMap subjectAttributes, AssertionType ssoAssertion, List<AssertionType> otherValidAssertions, String idpPartnerEntityId, String targetResourceUrl, String authnCtx, Date authnInstant) {
        this(subjectAttributes, ssoAssertion, otherValidAssertions, idpPartnerEntityId, targetResourceUrl, authnCtx);
        this.authenticationInstant = authnInstant;
    }

    @Deprecated
    public Map getSubjectAttributes() {
        HashMap<String, String> attrs = new HashMap<String, String>(this.subjectAttributes.size());
        for (Map.Entry<String, AttributeValue> entry : this.subjectAttributes.entrySet()) {
            attrs.put(entry.getKey(), entry.getValue() == null ? "" : entry.getValue().getValueMaskNull());
        }
        return attrs;
    }

    public Map<String, AttributeValue> getSubjectAttrs() {
        return this.subjectAttributes;
    }

    public String getIdpPartnerEntityId() {
        return this.idpPartnerEntityId;
    }

    public String getTargetResourceUrl() {
        return this.targetResourceUrl;
    }

    public void setTargetResourceUrl(String targetResourceUrl) {
        this.targetResourceUrl = targetResourceUrl;
    }

    public AssertionType getSsoAssertion() {
        return this.ssoAssertion;
    }

    public List<AssertionType> getOtherValidAssertions() {
        return this.otherValidAssertions;
    }

    public String getAuthenticationContext() {
        return this.authnCtx;
    }

    public Date getAuthenticationInstant() {
        return this.authenticationInstant;
    }
}

