/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.adapter.state;

import com.pingidentity.sdk.internal.services.ArgPair;
import com.pingidentity.sdk.internal.services.ServiceFactory;
import com.pingidentity.sdk.internal.services.interfaces.SessionStateSupportService;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TransactionalStateSupport {
    private final SessionStateSupportService sessionStateSupportService = ServiceFactory.getSingleImpl(SessionStateSupportService.class, new ArgPair[0]);
    private final String resumePath;

    public TransactionalStateSupport(String resumePath) {
        this.resumePath = resumePath;
    }

    public void setAttribute(String name, Object value, HttpServletRequest req, HttpServletResponse resp) {
        this.sessionStateSupportService.setAttribute(this.buildNameCtxKey(name), value, req, resp, false);
    }

    public Object getAttribute(String name, HttpServletRequest req, HttpServletResponse resp) {
        return this.sessionStateSupportService.getAttribute(this.buildNameCtxKey(name), req, resp);
    }

    public Object removeAttribute(String name, HttpServletRequest req, HttpServletResponse resp) {
        return this.sessionStateSupportService.removeAttribute(this.buildNameCtxKey(name), req, resp);
    }

    public String getTransactionalContextId() {
        return this.sessionStateSupportService.getContextId(this.resumePath);
    }

    public boolean hasTransactionalContextId() {
        return this.getTransactionalContextId() != null;
    }

    private String buildNameCtxKey(String name) {
        return this.hasTransactionalContextId() ? name + this.sessionStateSupportService.getContextDelimiter() + this.getTransactionalContextId() : name;
    }
}

