/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.saml20.domain.datasource.tag;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.pingidentity.common.util.ServerUrlUtils;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.sourceid.saml20.domain.datasource.tag.DataSourceTag;
import org.sourceid.saml20.domain.datasource.tag.DataSourceTagConfig;
import org.sourceid.saml20.domain.datasource.tag.LdapInstanceIdentifier;

@ApiModel(description="An LDAP data store's hostnames and tags configuration. For regional deployments, provide a separate LdapTagConfig for each region, containing region-specific hostnames and the corresponding tags.", parent=DataSourceTag.class)
@JsonPropertyOrder(value={"hostnames", "tags", "defaultSource"})
public class LdapTagConfig
implements DataSourceTagConfig,
Serializable,
Cloneable {
    private static final long serialVersionUID = -6515899420486698194L;
    private LdapInstanceIdentifier identifier;
    private DataSourceTag tagConfig;

    public LdapTagConfig(LdapInstanceIdentifier identifier, String tags, boolean isDefault) {
        this.tagConfig = new DataSourceTag(tags, isDefault);
        this.identifier = identifier;
    }

    @JsonCreator
    public LdapTagConfig(@JsonProperty(value="hostnames") List<String> hostnames, @JsonProperty(value="tags") String tags, @JsonProperty(value="defaultSource") boolean isDefault) {
        this.tagConfig = new DataSourceTag(tags, isDefault);
        this.identifier = new LdapInstanceIdentifier(hostnames);
    }

    @Override
    @JsonIgnore
    public LdapInstanceIdentifier getIdentifier() {
        return this.identifier;
    }

    @Override
    @JsonIgnore
    public Set<String> getTagsHashSet() {
        if (this.tagConfig != null) {
            return this.tagConfig.getTagsHashSet();
        }
        return new HashSet<String>();
    }

    @ApiModelProperty(position=10, value="The LDAP host names. Failover can be configured by providing multiple host names.", required=true)
    public List<String> getHostnames() {
        return this.identifier != null ? Arrays.asList(ServerUrlUtils.splitServerUrls(this.identifier.getHostname())) : new ArrayList<String>();
    }

    public void setHostnames(List<String> hostnames) {
        this.identifier = new LdapInstanceIdentifier(hostnames);
    }

    @Override
    @ApiModelProperty(position=50, value="Tags associated with the host names. At runtime, nodes will use the first LdapTagConfig that has a tag that matches with node.tags in run.properties.")
    public String getTags() {
        if (this.tagConfig != null) {
            if (StringUtils.isEmpty((CharSequence)this.tagConfig.getTags())) {
                return null;
            }
            return this.tagConfig.getTags();
        }
        return null;
    }

    @Override
    @ApiModelProperty(position=60, value="Whether this is the default connection. Defaults to false if not specified.")
    public boolean isDefaultSource() {
        return this.tagConfig != null && this.tagConfig.isDefaultSource();
    }

    public int hashCode() {
        int prime = 31;
        int result = 3;
        result = 31 * result + (this.identifier == null ? 0 : this.identifier.hashCode());
        result = 31 * result + (this.tagConfig == null ? 0 : this.tagConfig.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LdapTagConfig)) {
            return false;
        }
        return this.hashCode() == obj.hashCode();
    }

    public LdapTagConfig clone() throws CloneNotSupportedException {
        LdapTagConfig clone = (LdapTagConfig)super.clone();
        clone.identifier = this.identifier.clone();
        clone.tagConfig = this.tagConfig.clone();
        return clone;
    }
}

