/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.util.log;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.adapter.attribute.AttributeValue;

public class AttributeMap
extends HashMap<String, AttributeValue> {
    private static final long serialVersionUID = 20050515L;
    private static final Log log = LogFactory.getLog(AttributeMap.class);
    private boolean maskOgnlValues;

    public AttributeMap(Map<String, AttributeValue> attributes) {
        if (attributes != null) {
            this.putAll((Map<? extends String, ? extends AttributeValue>)attributes);
        }
    }

    public AttributeMap() {
    }

    @Override
    public void put(String key, String value) {
        this.put(key, new AttributeValue(value));
    }

    @Override
    public void putAll(Map<? extends String, ? extends AttributeValue> m) {
        m.forEach(this::put);
    }

    @Override
    public AttributeValue put(String key, AttributeValue value) {
        if (value != null && value.getValue() != null) {
            return super.put(key, value);
        }
        if (value != null && value.getObjectValue() != null) {
            return super.put(key, value);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Ignoring attempt to add null value to attribute map for " + key));
        }
        return null;
    }

    public void putIfNotPresent(String key, AttributeValue value) {
        if (!this.containsKey(key)) {
            this.put(key, value);
        }
    }

    public static String toString(Map<String, AttributeValue> map) {
        if (map == null) {
            return "null";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        Iterator<Map.Entry<String, AttributeValue>> i = map.entrySet().iterator();
        boolean hasNext = i.hasNext();
        while (hasNext) {
            Map.Entry<String, AttributeValue> e = i.next();
            String key = e.getKey();
            AttributeValue value = e.getValue();
            sb.append(key).append("=");
            String val = null;
            if (value != null) {
                val = value.sensitiveToString();
            }
            sb.append(val);
            hasNext = i.hasNext();
            if (!hasNext) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    @Override
    public String toString() {
        return AttributeMap.toString(this);
    }

    public Set<String> getMaskedAttributeNames() {
        HashSet<String> names = new HashSet<String>();
        for (Map.Entry e : this.entrySet()) {
            AttributeValue v = (AttributeValue)e.getValue();
            if (v == null || !v.isMasked()) continue;
            names.add((String)e.getKey());
        }
        return names;
    }

    public String getSingleValue(String name) {
        return this.getSingleValue(name, false);
    }

    public String getSingleValue(String name, boolean enforceMasking) {
        AttributeValue value = (AttributeValue)this.get(name);
        return value != null ? value.getValue(enforceMasking) : null;
    }

    public boolean getMaskOgnlValues() {
        return this.maskOgnlValues;
    }

    public void setMaskOgnlValues(boolean maskOgnlValues) {
        this.maskOgnlValues = maskOgnlValues;
    }
}

