/*
 * Decompiled with CFR 0.152.
 */
package org.sourceid.websso.servlet.adapter;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.websso.servlet.adapter.Handler;

public class HandlerRegistry {
    private static Log log = LogFactory.getLog(HandlerRegistry.class);
    private static Map<String, Handler> handlers = new HashMap<String, Handler>();
    private static Handler handler404 = (req, resp) -> resp.sendError(404);

    public static synchronized void registerHandler(String path, Handler handler) {
        log.info((Object)("Registering " + handler + " at " + path));
        handlers.put(path, handler);
    }

    public static synchronized Handler getHandler(String path) {
        Handler handler = handlers.get(path);
        return handler != null ? handler : handler404;
    }
}

