/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.component.module.connection.saasprovisioner;

import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletCard;
import com.pingidentity.fsm.tasklet.data.ChannelItem;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.impl.SaaSChannelTasklet;
import com.pingidentity.provisioner.domain.Channel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.tapestry.IBinding;
import org.apache.tapestry.IRequestCycle;

public abstract class ChannelList
extends TaskletCard {
    public abstract IBinding getChannelsBinding();

    public abstract IBinding getStateBinding();

    private State getState() {
        State state = (State)this.getStateBinding().getObject("state", Object.class);
        return state == null ? new State() : state;
    }

    public List<ChannelItem> getChannelsList() {
        return (List)this.getChannelsBinding().getObject("channels", ArrayList.class);
    }

    private void saveState(State curState) {
        this.getStateBinding().setObject((Object)curState);
    }

    public void edit(IRequestCycle cycle) {
        ChannelItem channel;
        Object[] params = cycle.getServiceParameters();
        Integer channelToEdit = (Integer)params[0];
        if (channelToEdit != null && (channel = this.getDisplayList().get(channelToEdit)) != null) {
            SaaSChannelTasklet tasklet = channel.getTasklet();
            tasklet.setSaveDraftAvailable(false);
            tasklet.markProtocolImgAvailable(true);
            tasklet.setSourceSelectionStateChanged(false);
            this.loadTasklet((Tasklet)tasklet);
            tasklet.gotoSummaryState(cycle);
        }
    }

    protected void prepareForRender(IRequestCycle arg0) {
        super.prepareForRender(arg0);
        State state = this.getState();
        state.sortBy = SORT_BY.Name;
        state.sortNameUp = false;
        state.displayList = new ArrayList<ChannelItem>();
        for (ChannelItem item : this.getChannelsList()) {
            state.displayList.add(item);
        }
        switch (state.sortBy) {
            case Name: {
                if (state.sortNameUp) {
                    Collections.sort(state.displayList, ChannelItem.COMPARE_BY_NAME_UP);
                    break;
                }
                Collections.sort(state.displayList, ChannelItem.COMPARE_BY_NAME_DOWN);
            }
        }
        this.saveState(state);
    }

    public List<ChannelItem> getDisplayList() {
        State state = this.getState();
        return state.displayList;
    }

    public void delete(IRequestCycle cycle) {
        if (this.isCurrentUserAdmin()) {
            Object[] params = cycle.getServiceParameters();
            String channelToDelete = (String)params[0];
            for (ChannelItem channelItem : this.getChannelsList()) {
                if (!channelItem.getChannelId().equals(channelToDelete)) continue;
                channelItem.setDeleted(!channelItem.isDeleted());
            }
        } else {
            this.auditLogUnauthorizedUserDeleteAction("channel list");
        }
    }

    public void copy(IRequestCycle cycle) {
        Object[] params = cycle.getServiceParameters();
        String channelToDelete = (String)params[0];
        for (ChannelItem channelItem : this.getChannelsList()) {
            if (!channelItem.getChannelId().equals(channelToDelete)) continue;
            Channel channelToCopy = channelItem.getTasklet().getChannel();
            Channel copyChannel = new Channel(channelToCopy);
            Long randomId = new Date().getTime();
            int negRandId = Math.abs(randomId.intValue()) * -1;
            copyChannel.setId(negRandId);
            SaaSChannelTasklet copyChannelTasklet = (SaaSChannelTasklet)this.loadNewTasklet(SaaSChannelTasklet.class);
            copyChannelTasklet.gotoGeneralInfoState();
            copyChannelTasklet.setSaveDraftAvailable(false);
            copyChannelTasklet.markProtocolImgAvailable(true);
            copyChannelTasklet.setMode(Mode.edit);
            copyChannelTasklet.populate(copyChannel);
            break;
        }
    }

    private class State
    implements Serializable {
        private static final long serialVersionUID = 20050515L;
        boolean sortNameUp;
        boolean sortSourceUp;
        SORT_BY sortBy = SORT_BY.Name;
        List<ChannelItem> displayList;

        private State() {
        }
    }

    private static enum SORT_BY {
        Name,
        Source;

    }
}

