/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.component.common.StringListEditor;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.impl.SaaSCustomScimAttributeTasklet;
import com.pingidentity.fsm.tasklet.impl.SaaSManagementTasklet;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.CoreUserOutboundScimAttributeConstants;
import org.sourceid.saml20.domain.scim.model.SchemaAttribute;
import org.sourceid.saml20.domain.scim.model.SchemaSubAttribute;

public class SaaSCustomScimAttributeState
extends TaskletState {
    private static final long serialVersionUID = 1L;
    String menuName = "Custom SCIM Attribute";
    private String attributeName;
    private boolean multiValued;
    private List<String> subAttributesNamesList = new ArrayList<String>();
    private List<String> types = new ArrayList<String>();
    private transient Object subAttributesNamesState;
    private transient Object attributeTypesState;
    public List<String> availableTypes;

    public SaaSCustomScimAttributeState(Tasklet value, String name) {
        super((IWizard)value, name);
        this.setMenuName(this.menuName);
    }

    public void populate(Object dataFromDisk) {
        if (dataFromDisk != null) {
            SchemaAttribute schemaAttribute = (SchemaAttribute)dataFromDisk;
            this.attributeName = schemaAttribute.getName();
            this.multiValued = schemaAttribute.isMultiValued();
            this.types.clear();
            ArrayList<String> names = new ArrayList<String>();
            if (schemaAttribute.getSubAttributes() != null) {
                for (SchemaSubAttribute schemaSubAttribute : schemaAttribute.getSubAttributes()) {
                    if (!schemaSubAttribute.getName().equalsIgnoreCase("type") || schemaSubAttribute.getName().equalsIgnoreCase("type") && schemaSubAttribute.getCanonicalValues().size() == 0) {
                        names.add(schemaSubAttribute.getName());
                        continue;
                    }
                    this.setTypes(new ArrayList<String>(schemaSubAttribute.getCanonicalValues()));
                }
            }
            this.setSubAttributesNamesList(names);
        }
    }

    public boolean save(Object dataToDisk) {
        if (dataToDisk != null) {
            SchemaAttribute schemaAttribute = (SchemaAttribute)dataToDisk;
            schemaAttribute.setName(this.attributeName);
            schemaAttribute.setMultiValued(Boolean.valueOf(this.multiValued));
            ArrayList<SchemaSubAttribute> subAttributes = new ArrayList<SchemaSubAttribute>();
            for (String name : this.getSubAttributesNamesList()) {
                SchemaSubAttribute schemaSubAttribute = new SchemaSubAttribute();
                schemaSubAttribute.setName(name);
                subAttributes.add(schemaSubAttribute);
            }
            if (this.isMultiValued() && this.types.size() > 0) {
                SchemaSubAttribute schemaSubAttribute = new SchemaSubAttribute();
                schemaSubAttribute.setName("type");
                schemaSubAttribute.getCanonicalValues().addAll(this.types);
                subAttributes.add(schemaSubAttribute);
            }
            if (schemaAttribute.getSubAttributes() == null) {
                schemaAttribute.setSubAttributes(new ArrayList());
            }
            schemaAttribute.getSubAttributes().addAll(subAttributes);
            if (schemaAttribute.getSubAttributes().size() > 0) {
                schemaAttribute.setType("complex");
            }
            this.subAttributesNamesState = null;
            this.attributeTypesState = null;
        }
        return true;
    }

    public void reset() {
        this.setSubAttributesNamesState(null);
        this.setAttributeTypesState(null);
        this.subAttributesNamesList.clear();
        this.types.clear();
    }

    public void cancel(Object newData) {
        super.cancel(newData);
        this.subAttributesNamesState = null;
        this.attributeTypesState = null;
    }

    public boolean onStateExit() {
        this.updateTypes();
        return true;
    }

    public void updateTypes() {
        if (this.attributeTypesState != null) {
            StringListEditor.State componentState = (StringListEditor.State)this.attributeTypesState;
            if (!this.multiValued) {
                componentState.deleteAllStringListItems();
            }
        }
    }

    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        this.validate(delegate);
        super.appendErrors(delegate, component, fastFail);
    }

    private void validate(IValidationDelegate delegate) {
        this.validateAttributeName(delegate);
        this.validateSubAttributes(delegate);
    }

    private void validateAttributeName(IValidationDelegate delegate) {
        if (this.attributeName != null) {
            if (StringUtils.isWhitespace((String)this.attributeName)) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("custom_attribute_name_invalid_blank_not_allowed"), ValidationConstraint.DISALLOWED_PROTOCOL);
            } else if (!StringUtils.isAlphanumeric((String)this.attributeName)) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("custom_attribute_name_invalid_alphanumeric_only"), ValidationConstraint.DISALLOWED_PROTOCOL);
            } else {
                for (String theOtherAttributeName : this.getTheOtherAttributeNames()) {
                    if (!this.attributeName.equalsIgnoreCase(theOtherAttributeName)) continue;
                    delegate.setFormComponent(null);
                    delegate.record(this.getMessage("custom_attribute_name_exists"), ValidationConstraint.CONSISTENCY);
                }
                if (!this.isCustomAttributeTextBoxDisabled()) {
                    for (String coreAttribute : CoreUserOutboundScimAttributeConstants.getAllIds()) {
                        if (!this.attributeName.equalsIgnoreCase(coreAttribute)) continue;
                        Object[] errorParams = new Object[]{this.attributeName};
                        delegate.setFormComponent(null);
                        delegate.record(this.getMessage("custom_attr_name_must_not_match_core_attr_id", errorParams), ValidationConstraint.REQUIRED);
                    }
                }
            }
        }
    }

    private void validateSubAttributes(IValidationDelegate delegate) {
        if (this.multiValued && this.types.size() > 0) {
            if (this.subAttributesNamesList.size() < 1) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("custom_sub_attributes_count"), ValidationConstraint.DISALLOWED_PROTOCOL);
            }
            for (String subAttrName : this.subAttributesNamesList) {
                if (!subAttrName.equalsIgnoreCase("type")) continue;
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("custom_sub_attributes_name"), ValidationConstraint.DISALLOWED_PROTOCOL);
            }
        }
        if (this.multiValued && this.subAttributesNamesList.size() > 0 && this.types.size() < 1) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("custom_attribute_types_count"), ValidationConstraint.DISALLOWED_PROTOCOL);
        }
        for (String subAttrName : this.subAttributesNamesList) {
            if (StringUtils.isAlphanumeric((String)subAttrName)) continue;
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("custom_sub_attribute_name_invalid_alphanumeric_only"), ValidationConstraint.DISALLOWED_PROTOCOL);
        }
        for (String type : this.types) {
            if (StringUtils.isAlphanumeric((String)type)) continue;
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("custom_type_name_invalid_alphanumeric_only"), ValidationConstraint.DISALLOWED_PROTOCOL);
        }
    }

    private List<String> getTheOtherAttributeNames() {
        SaaSManagementTasklet grandparent = (SaaSManagementTasklet)((Object)this.findParent(SaaSManagementTasklet.class));
        SaaSCustomScimAttributeTasklet parent = (SaaSCustomScimAttributeTasklet)((Object)this.findParent(SaaSCustomScimAttributeTasklet.class));
        return grandparent.getCustomAttributeNamesNotIncludingTasklet(parent.getTaskletId());
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public boolean isMultiValued() {
        return this.multiValued;
    }

    public void setMultiValued(boolean multiValued) {
        this.multiValued = multiValued;
    }

    public List<String> getTypes() {
        return this.types;
    }

    public void setTypes(List<String> types) {
        this.types = types;
    }

    public List<String> getSubAttributesNamesList() {
        return this.subAttributesNamesList;
    }

    public void setSubAttributesNamesList(List<String> names) {
        this.subAttributesNamesList = names;
    }

    public Object getSubAttributesNamesState() {
        return this.subAttributesNamesState;
    }

    public void setSubAttributesNamesState(Object componentState) {
        this.subAttributesNamesState = componentState;
        this.markMappedSubAttributes();
    }

    public Object getAttributeTypesState() {
        return this.attributeTypesState;
    }

    public void setAttributeTypesState(Object attributeTypesState) {
        this.attributeTypesState = attributeTypesState;
        this.markMappedTypes();
    }

    public List<String> getAvailableTypes() {
        if (this.availableTypes == null) {
            this.availableTypes = new ArrayList<String>();
        }
        return this.availableTypes;
    }

    public boolean isCustomAttributeTextBoxDisabled() {
        SaaSCustomScimAttributeTasklet parent = (SaaSCustomScimAttributeTasklet)((Object)this.findParent(SaaSCustomScimAttributeTasklet.class));
        return parent.isDeleteCustomAttributeDisabled();
    }

    public boolean isMultiValuedCheckboxDisabled() {
        SaaSCustomScimAttributeTasklet parent = (SaaSCustomScimAttributeTasklet)((Object)this.findParent(SaaSCustomScimAttributeTasklet.class));
        return parent.isDeleteCustomAttributeDisabled();
    }

    public boolean shouldHideSubAttributesOptions() {
        return this.isCustomAttributeTextBoxDisabled() && this.subAttributesNamesList.size() < 1;
    }

    public boolean shouldHideTypesOptions() {
        return !this.multiValued || this.isCustomAttributeTextBoxDisabled() && this.types.size() < 1;
    }

    private void markMappedSubAttributes() {
        SaaSCustomScimAttributeTasklet parent = (SaaSCustomScimAttributeTasklet)((Object)this.findParent(SaaSCustomScimAttributeTasklet.class));
        for (StringListEditor.StringListItem stringListItem : ((StringListEditor.State)this.subAttributesNamesState).getStringListItems()) {
            for (String mappedSubAttribute : parent.getMappedSubattributes()) {
                if (!stringListItem.getItemValue().equalsIgnoreCase(mappedSubAttribute)) continue;
                stringListItem.setEditDisabled(true);
                stringListItem.setDeleteDisabled(true);
            }
        }
    }

    private void markMappedTypes() {
        SaaSCustomScimAttributeTasklet parent = (SaaSCustomScimAttributeTasklet)((Object)this.findParent(SaaSCustomScimAttributeTasklet.class));
        for (StringListEditor.StringListItem stringListItem : ((StringListEditor.State)this.attributeTypesState).getStringListItems()) {
            for (String mappedType : parent.getMappedTypes()) {
                if (!stringListItem.getItemValue().equalsIgnoreCase(mappedType)) continue;
                stringListItem.setEditDisabled(true);
                stringListItem.setDeleteDisabled(true);
            }
        }
    }
}

