/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletListState;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.SaaSCustomScimAttributeTasklet;
import com.pingidentity.fsm.tasklet.impl.SaaSManagementTasklet;
import com.pingidentity.provisioner.domain.mgmt.ProvisionerConfig;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidationDelegate;
import org.sourceid.saml20.domain.CoreUserOutboundScimAttributeConstants;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.scim.model.Schema;
import org.sourceid.saml20.domain.scim.model.SchemaAttribute;

public class SaaSCustomScimAttributesState
extends TaskletListState {
    private static final long serialVersionUID = 1L;
    protected String customScimAttributeNameToAdd = "";
    protected String namespace = "urn:scim:schemas:extension:custom:1.0";

    public SaaSCustomScimAttributesState(Tasklet value, String name) {
        super((IWizard)value, name);
        this.setMenuName("Custom SCIM Attributes");
    }

    public void populate(Object dataFromDisk) {
        this.deleteAllTasklets();
        if (dataFromDisk != null) {
            SpConnection connection = (SpConnection)dataFromDisk;
            ProvisionerConfig provConfig = (ProvisionerConfig)connection.getModuleConfiguration(ProvisionerConfig.class);
            List<SchemaAttribute> schemaAttributeList = this.getCustomScimAttributesFromDisk(provConfig.getCustomScim());
            for (SchemaAttribute customScimAttribute : schemaAttributeList) {
                this.createTaskletForCustomAttribute(customScimAttribute);
            }
            if (provConfig.getCustomScim().getSchemas() != null && provConfig.getCustomScim().getSchemas().size() > 0) {
                this.namespace = (String)provConfig.getCustomScim().getSchemas().iterator().next();
            }
        }
    }

    private List<SchemaAttribute> getCustomScimAttributesFromDisk(Schema customScim) {
        ArrayList atts = customScim.getAttributes();
        if (atts == null) {
            atts = new ArrayList();
        }
        return atts;
    }

    private void createTaskletForCustomAttribute(SchemaAttribute customScimAttribute) {
        SaaSCustomScimAttributeTasklet customScimAttributeTasklet = (SaaSCustomScimAttributeTasklet)this.createTasklet(SaaSCustomScimAttributeTasklet.class);
        customScimAttributeTasklet.setMode(Mode.edit);
        customScimAttributeTasklet.populate(customScimAttribute);
        this.addTasklet(customScimAttributeTasklet);
    }

    public boolean save(Object dataToDisk) {
        ArrayList<SchemaAttribute> schemaAttributesList = new ArrayList<SchemaAttribute>();
        for (Tasklet tasklet : this.getTasklets()) {
            SaaSCustomScimAttributeTasklet customScimAttributeTasklet = (SaaSCustomScimAttributeTasklet)tasklet;
            if (customScimAttributeTasklet.isItDeleted()) continue;
            SchemaAttribute schemaAttribute = new SchemaAttribute();
            schemaAttribute.setSchema(this.namespace);
            customScimAttributeTasklet.save(schemaAttribute);
            schemaAttributesList.add(schemaAttribute);
        }
        SpConnection connection = (SpConnection)dataToDisk;
        ProvisionerConfig provConfig = (ProvisionerConfig)connection.getModuleConfiguration(ProvisionerConfig.class);
        ArrayList atts = provConfig.getCustomScim().getAttributes();
        if (atts == null) {
            atts = new ArrayList();
        }
        atts.clear();
        atts.addAll(schemaAttributesList);
        provConfig.getCustomScim().setAttributes(atts);
        provConfig.getCustomScim().getSchemas().clear();
        provConfig.getCustomScim().getSchemas().add(this.namespace);
        return true;
    }

    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (this.namespace.equals("") && !this.getAllUndeletedTasklets().isEmpty()) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("extension_namespace_cannot_be_blank"), ValidationConstraint.REQUIRED);
        }
    }

    public String getCustomScimAttributeNameToAdd() {
        return this.customScimAttributeNameToAdd;
    }

    public void setCustomScimAttributeNameToAdd(String customScimAttributeNameToAdd) {
        this.customScimAttributeNameToAdd = customScimAttributeNameToAdd;
    }

    public void addCustomAttributeName() {
        if (this.passedValidation()) {
            SchemaAttribute schemaAttributeToAdd = new SchemaAttribute();
            schemaAttributeToAdd.setName(this.customScimAttributeNameToAdd);
            schemaAttributeToAdd.setMultiValued(Boolean.valueOf(false));
            schemaAttributeToAdd.setDescription(this.customScimAttributeNameToAdd);
            schemaAttributeToAdd.setSubAttributes(null);
            this.createTaskletForCustomAttribute(schemaAttributeToAdd);
            this.customScimAttributeNameToAdd = "";
        }
    }

    private boolean passedValidation() {
        ValidationDelegate delegate = this.getParent().getDelegate();
        this.validateAttributeName(delegate);
        return !delegate.getHasErrors();
    }

    private void validateAttributeName(ValidationDelegate delegate) {
        if (this.customScimAttributeNameToAdd != null) {
            if (StringUtils.isWhitespace((String)this.customScimAttributeNameToAdd)) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("custom_attribute_name_invalid_blank_not_allowed"), ValidationConstraint.DISALLOWED_PROTOCOL);
            } else if (!StringUtils.isAlphanumeric((String)this.customScimAttributeNameToAdd)) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("custom_attribute_name_invalid_alphanumeric_only"), ValidationConstraint.DISALLOWED_PROTOCOL);
            } else {
                for (String theOtherAttributeName : this.getAllCustomAttributeNames()) {
                    if (!this.customScimAttributeNameToAdd.equalsIgnoreCase(theOtherAttributeName)) continue;
                    delegate.setFormComponent(null);
                    delegate.record(this.getMessage("custom_attribute_name_exists"), ValidationConstraint.CONSISTENCY);
                }
                for (String coreAttribute : CoreUserOutboundScimAttributeConstants.getAllIds()) {
                    if (!this.customScimAttributeNameToAdd.equalsIgnoreCase(coreAttribute)) continue;
                    Object[] errorParams = new Object[]{this.customScimAttributeNameToAdd};
                    delegate.setFormComponent(null);
                    delegate.record(this.getMessage("custom_attr_name_must_not_match_core_attr_id", errorParams), ValidationConstraint.REQUIRED);
                }
            }
        }
    }

    public Tasklet getTaskletForCustomAttributeName(String customScimAttributeName) {
        for (Tasklet tasklet : this.getTasklets()) {
            SaaSCustomScimAttributeTasklet t = (SaaSCustomScimAttributeTasklet)tasklet;
            if (!t.getAttributeName().equals(customScimAttributeName)) continue;
            tasklet.initialize();
            return tasklet;
        }
        return null;
    }

    public void delete(String customAttributeToDelete) {
        for (Tasklet tasklet : this.getTasklets()) {
            SaaSCustomScimAttributeTasklet t = (SaaSCustomScimAttributeTasklet)tasklet;
            if (!t.getAttributeName().equals(customAttributeToDelete)) continue;
            t.setItDeleted(true);
            return;
        }
    }

    public void undelete(String customAttributeToUndelete) {
        for (Tasklet tasklet : this.getTasklets()) {
            SaaSCustomScimAttributeTasklet t = (SaaSCustomScimAttributeTasklet)tasklet;
            if (!t.getAttributeName().equals(customAttributeToUndelete)) continue;
            t.setItDeleted(false);
            return;
        }
    }

    private List<String> getAttributeNamesListFromSchemaAttributesList(List<SchemaAttribute> schemaAttributes) {
        ArrayList<String> attrNames = new ArrayList<String>();
        for (SchemaAttribute schemaAttribute : schemaAttributes) {
            attrNames.add(schemaAttribute.getName());
        }
        return attrNames;
    }

    public List<String> getAttributeNamesNotIncludingTasklet(String excludedTaskletId) {
        ArrayList<String> attrNames = new ArrayList<String>();
        List allTasklets = this.getTasklets();
        for (Tasklet tasklet : allTasklets) {
            if (tasklet.getTaskletId().equals(excludedTaskletId)) continue;
            attrNames.add(((SaaSCustomScimAttributeTasklet)tasklet).getAttributeName());
        }
        return attrNames;
    }

    public List<String> getAllCustomAttributeNames() {
        ArrayList<String> attrNames = new ArrayList<String>();
        for (Tasklet tasklet : this.getTasklets()) {
            attrNames.add(((SaaSCustomScimAttributeTasklet)tasklet).getAttributeName());
        }
        return attrNames;
    }

    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo(this.getMessage("extension_namespace"), this.namespace, (TaskletState)this));
        for (Tasklet tasklet : this.getTasklets()) {
            summaryList.add(new SummaryInfo(this.getMessage("custom_attribute"), ((SaaSCustomScimAttributeTasklet)tasklet).getAttributeName(), (TaskletState)this));
        }
    }

    private List<Tasklet> getAllUndeletedTasklets() {
        ArrayList<Tasklet> undeletedTaskletsList = new ArrayList<Tasklet>();
        for (Tasklet tasklet : this.getTasklets()) {
            if (tasklet.isDraft()) continue;
            undeletedTaskletsList.add(tasklet);
        }
        return undeletedTaskletsList;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public void onStateActivated() {
        this.registerTaskletsWithMappedAttributes();
    }

    private void registerTaskletsWithMappedAttributes() {
        SaaSManagementTasklet saaSManagementTasklet = (SaaSManagementTasklet)this.getParent();
        Set<String> currentlyMappedAttributes = saaSManagementTasklet.getAllUniqueFieldNamesFromIdentityMappingFieldsInChannelTasklets();
        List<String> mappedAttrNames = this.getAttributeNamesForMappedAttrGroupIds();
        Map<String, List<String>> customAttributeIds = saaSManagementTasklet.getCustomAttributeGroups();
        for (Tasklet tasklet : this.getTasklets()) {
            ((SaaSCustomScimAttributeTasklet)tasklet).setDeleteCustomAttributeDisabled(false);
            ((SaaSCustomScimAttributeTasklet)tasklet).setMappedSubattributes(new ArrayList<String>());
            ((SaaSCustomScimAttributeTasklet)tasklet).setMappedTypes(new ArrayList<String>());
        }
        for (String attributeInUse : mappedAttrNames) {
            for (Tasklet tasklet : this.getTasklets()) {
                if (!((SaaSCustomScimAttributeTasklet)tasklet).getAttributeName().equalsIgnoreCase(attributeInUse)) continue;
                ((SaaSCustomScimAttributeTasklet)tasklet).setDeleteCustomAttributeDisabled(true);
                List<String> groupIdsForAttributeInUse = customAttributeIds.get(attributeInUse);
                for (String attrGroupId : groupIdsForAttributeInUse) {
                    if (!currentlyMappedAttributes.contains(attrGroupId)) continue;
                    this.parseMappedCustomAttrGroupId((SaaSCustomScimAttributeTasklet)tasklet, attrGroupId);
                }
            }
        }
    }

    private void parseMappedCustomAttrGroupId(SaaSCustomScimAttributeTasklet customScimAttributeTasklet, String attrGroupId) {
        String[] parsedGroupId = attrGroupId.split("\\.");
        if (parsedGroupId.length != 1) {
            if (parsedGroupId.length == 2) {
                if (parsedGroupId[1] != null && parsedGroupId[1].length() > 0) {
                    customScimAttributeTasklet.getMappedSubattributes().add(parsedGroupId[1]);
                }
            } else if (parsedGroupId.length == 3) {
                if (parsedGroupId[1] != null && parsedGroupId[1].length() > 0) {
                    customScimAttributeTasklet.getMappedTypes().add(parsedGroupId[1]);
                }
                if (parsedGroupId[2] != null && parsedGroupId[2].length() > 0) {
                    customScimAttributeTasklet.getMappedSubattributes().add(parsedGroupId[2]);
                }
            }
        }
    }

    private List<String> getAttributeNamesForMappedAttrGroupIds() {
        SaaSManagementTasklet saaSManagementTasklet = (SaaSManagementTasklet)this.getParent();
        Set<String> namesFromIdentityMappingFieldsInChannelTasklets = saaSManagementTasklet.getAllUniqueFieldNamesFromIdentityMappingFieldsInChannelTasklets();
        Map<String, List<String>> customAttributeIds = saaSManagementTasklet.getCustomAttributeGroups();
        HashSet<String> attrNamesForMappedAttrGroupIds = new HashSet<String>();
        for (String attributeName : customAttributeIds.keySet()) {
            List<String> customAttrGroupIds = customAttributeIds.get(attributeName);
            for (String customAttrGroupId : customAttrGroupIds) {
                if (!namesFromIdentityMappingFieldsInChannelTasklets.contains(customAttrGroupId)) continue;
                attrNamesForMappedAttrGroupIds.add(attributeName);
            }
        }
        return new ArrayList<String>(attrNamesForMappedAttrGroupIds);
    }

    public boolean onStateExit() {
        ((SaaSManagementTasklet)this.getParent()).refreshAttributeMappingTaskletsInChannels();
        return super.onStateExit();
    }
}

