/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.state.impl.SaaSProvisioningState;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.SaaSChannelTasklet;
import com.pingidentity.fsm.tasklet.impl.SpConnectionConfigTasklet;
import com.pingidentity.provisioner.domain.Channel;
import com.pingidentity.provisioner.saas.SaasPluginManager;
import com.pingidentity.provisioner.saas.SaasProvisionerPlugin;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;

public class SaaSGeneralInfoState
extends TaskletState {
    private static final long serialVersionUID = 2L;
    private String name = "";
    private int channelId = -1;
    private String maxThreads = "1";
    private String timeout = "60";

    public SaaSGeneralInfoState(IWizard owner) {
        super(owner);
        this.setMenuName("Channel Info");
    }

    public void populate(Object dataFromDisk) {
        if (dataFromDisk instanceof Channel) {
            Channel channel = (Channel)dataFromDisk;
            this.name = channel.getName();
            this.maxThreads = String.valueOf(channel.getMaxThreads());
            if (channel.getTimeout() > 0) {
                this.timeout = String.valueOf(channel.getTimeout());
            }
            this.channelId = channel.getId();
        }
    }

    public boolean save(Object dataToDisk) {
        Channel channel = (Channel)dataToDisk;
        channel.setId(this.channelId);
        channel.setName(this.name);
        channel.setMaxThreads(Integer.parseInt(this.maxThreads));
        channel.setTimeout(Integer.parseInt(this.timeout));
        return true;
    }

    public void onStateActivated() {
        if (this.channelId == -1) {
            int defaultTimeout;
            String selectedPluginId = ((SpConnectionConfigTasklet)this.findParent(SpConnectionConfigTasklet.class)).getSelectedConnectionModuleType(SaaSProvisioningState.class);
            SaasProvisionerPlugin saasProvPlugin = SaasPluginManager.getInstance().getPluginInstance(selectedPluginId);
            int defaultMaxThreads = saasProvPlugin.getDefaultMaxThreads();
            if (defaultMaxThreads > 0) {
                this.maxThreads = String.valueOf(defaultMaxThreads);
            }
            if ((defaultTimeout = saasProvPlugin.getDefaultTimeout()) > 0) {
                this.timeout = String.valueOf(defaultTimeout);
            }
        }
    }

    public void onResumeDraft() {
    }

    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (StringUtils.isBlank((String)this.name)) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Channel_name_required"), ValidationConstraint.REQUIRED);
        }
        if (StringUtils.isBlank((String)this.maxThreads)) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Max_threads_required"), ValidationConstraint.REQUIRED);
        } else {
            try {
                Integer maxThrd = new Integer(this.maxThreads);
                if (maxThrd < 1 || maxThrd > 10000) {
                    delegate.setFormComponent(null);
                    delegate.record(this.getMessage("Max_threads_invalid"), ValidationConstraint.REQUIRED);
                }
            }
            catch (NumberFormatException nfe) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Max_threads_invalid"), ValidationConstraint.REQUIRED);
            }
        }
        if (StringUtils.isBlank((String)this.timeout)) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("timeout_required"), ValidationConstraint.REQUIRED);
        } else if (NumberUtils.toInt((String)this.timeout) < 1) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("timeout_invalid"), ValidationConstraint.REQUIRED);
        }
        SaaSChannelTasklet t = (SaaSChannelTasklet)((Object)this.findParent(SaaSChannelTasklet.class));
        if (t.doesChannelNameExist(this.name, Integer.toString(this.channelId))) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Channel_name_must_be_unique"), ValidationConstraint.REQUIRED);
        }
    }

    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo("Channel Name", this.getName(), (TaskletState)this));
        summaryList.add(new SummaryInfo("Max Threads", this.getMaxThreads(), (TaskletState)this));
        summaryList.add(new SummaryInfo("Timeout", this.getTimeout(), (TaskletState)this));
    }

    public boolean isSaveDraftAvailable() {
        return false;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getMaxThreads() {
        return this.maxThreads;
    }

    public void setMaxThreads(String maxThreads) {
        this.maxThreads = maxThreads;
    }

    public String getChannelId() {
        return Integer.toString(this.channelId);
    }

    public boolean isNewChannel() {
        return this.channelId == -1;
    }

    public String getTimeout() {
        return this.timeout;
    }

    public void setTimeout(String timeout) {
        this.timeout = timeout;
    }
}

