/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.module.connection.admin.ServerSettingsState;
import com.pingidentity.provisioner.domain.Channel;
import com.pingidentity.provisioner.domain.ProvisionerGlobalSettings;
import com.pingidentity.provisioner.domain.mgmt.ProvisionerConfig;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.JdbcDataSource;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class SaaSGlobalProvisioningSettingsState
extends TaskletState
implements ServerSettingsState {
    private static final long serialVersionUID = 20050515L;
    private DataSource.DSType dataSourceType = DataSource.DSType.None;
    private DataSource selectedDataSource;
    private DataSource selectedDataSourceOnPopulate;
    private String selectedDataSourceId = "";
    private String dataSourceDesc = "";
    private StringPairPropertySelectionModel activeDataSourceList = new StringPairPropertySelectionModel();
    private String synchFreq = "";
    private int SYNCH_FREQ_MIN = 0;

    public SaaSGlobalProvisioningSettingsState(Tasklet ownerTasklet) {
        super((IWizard)ownerTasklet);
        this.setMenuName("Outbound Provisioning");
    }

    public boolean populateAllStates(Object data) {
        LocalSettings localSettings = (LocalSettings)data;
        ProvisionerGlobalSettings pvSettings = (ProvisionerGlobalSettings)localSettings.getConnectionModuleGlobalConfiguration(ProvisionerGlobalSettings.class);
        try {
            this.synchFreq = Integer.toString(pvSettings.getSyncInterval());
        }
        catch (NumberFormatException e) {
            this.log.debug((Object)"There was a problem retrieving the Synchronization Frequency.  It's not a valid number.");
        }
        this.selectedDataSourceId = pvSettings.getInternalDataSourceId();
        if (this.selectedDataSourceId != null) {
            DataSourceManager dsMgr = MgmtFactory.getDataSourceManager();
            this.selectedDataSource = this.selectedDataSourceOnPopulate = dsMgr.getJdbcDataSource(this.selectedDataSourceId);
        }
        this.populate();
        return true;
    }

    private void populate() {
        ArrayList<DataSource> dataSources = this.loadDataSources();
        this.createActiveDataSourceModel(dataSources);
        if (this.selectedDataSource != null) {
            for (DataSource ds : dataSources) {
                if (!ds.getId().equals(this.selectedDataSource.getId())) continue;
                this.selectedDataSource = ds;
                this.selectedDataSourceId = this.selectedDataSource.getId();
                this.dataSourceDesc = ds.getDescription();
                this.determineType(ds);
            }
        }
    }

    public void onStateActivated() {
        if (this.selectedDataSource == null || this.activeDataSourceList == null) {
            this.populate();
        }
    }

    public void refreshState() {
        this.populate();
    }

    public void formListener(IRequestCycle cycle) {
        if (this.selectedDataSource != null) {
            this.dataSourceDesc = this.selectedDataSource.getDescription();
            this.selectedDataSourceId = this.selectedDataSource.getId();
            this.determineType(this.selectedDataSource);
        } else {
            this.dataSourceDesc = null;
            this.dataSourceType = DataSource.DSType.None;
        }
    }

    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if ("".equals(this.synchFreq)) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Synch_Freq_required"), ValidationConstraint.REQUIRED);
        } else {
            try {
                Long synchFreqLong = Long.parseLong(this.synchFreq);
                Long synchFreq = synchFreqLong * 1000L;
                if (synchFreq <= (long)this.SYNCH_FREQ_MIN) {
                    delegate.setFormComponent(null);
                    delegate.record(this.getMessage("Synch_freq_int_range_error"), ValidationConstraint.REQUIRED);
                }
            }
            catch (NumberFormatException nfe) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Synch_freq_int_range_error"), ValidationConstraint.REQUIRED);
            }
        }
        if (this.selectedDataSource == null) {
            Collection allSpConnections = MgmtFactory.getConnectionManager().getAllSpConnections();
            for (ConnectionBase connection : allSpConnections) {
                ProvisionerConfig provisionerConfig;
                if (!connection.isActive() || (provisionerConfig = (ProvisionerConfig)connection.getModuleConfiguration(ProvisionerConfig.class)) == null) continue;
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Internal_data_store_required"), ValidationConstraint.REQUIRED);
                break;
            }
        }
    }

    public boolean save(Object dataToDisk) {
        LocalSettings localSettings = (LocalSettings)dataToDisk;
        ProvisionerGlobalSettings pvSettings = (ProvisionerGlobalSettings)localSettings.getConnectionModuleGlobalConfiguration(ProvisionerGlobalSettings.class);
        if (!pvSettings.isEnabledInGui()) {
            this.log.debug((Object)"Resetting SaaS Global Provisioning settings...");
            pvSettings.setSyncInterval(60);
            pvSettings.setInternalDataSourceId("");
        } else {
            pvSettings.setSyncInterval(Integer.parseInt(this.synchFreq));
            pvSettings.setInternalDataSourceId(this.selectedDataSource != null ? this.selectedDataSource.getId() : "");
        }
        return true;
    }

    public static boolean isEnableSaasProvisioner(LocalSettings localSettings) {
        ProvisionerGlobalSettings pvSettings = (ProvisionerGlobalSettings)localSettings.getConnectionModuleGlobalConfiguration(ProvisionerGlobalSettings.class);
        return pvSettings != null && pvSettings.isEnabledInGui();
    }

    protected ArrayList<DataSource> loadDataSources() {
        DataSourceManager dataMgr = MgmtFactory.getDataSourceManager();
        ArrayList<DataSource> dataSources = new ArrayList<DataSource>();
        dataSources.addAll(dataMgr.getJdbcDataSources());
        return dataSources;
    }

    private void createActiveDataSourceModel(ArrayList<DataSource> dataSources) {
        this.activeDataSourceList = new StringPairPropertySelectionModel(true);
        for (DataSource ds : dataSources) {
            this.activeDataSourceList.add(ds.getDescription(), (Object)ds);
        }
        this.activeDataSourceList.sort();
    }

    private void determineType(DataSource ds) {
        this.dataSourceType = ds instanceof JdbcDataSource ? DataSource.DSType.JDBC : DataSource.DSType.None;
    }

    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo("Internal Provisioning Data Store", this.getDataSourceDesc(), (TaskletState)this));
        summaryList.add(new SummaryInfo("Data Store Type", this.getDataSourceTypeString(), (TaskletState)this));
        summaryList.add(new SummaryInfo("Synchronization Frequency (secs)", Integer.valueOf(this.getSynchFreq()).toString(), (TaskletState)this));
    }

    public String getDataSourceTypeString() {
        return DataSource.getTypeDescription((DataSource.DSType)this.dataSourceType);
    }

    public DataSource.DSType getDataSourceType() {
        return this.dataSourceType;
    }

    public void setDataSourceType(DataSource.DSType dataSourceType) {
        this.dataSourceType = dataSourceType;
    }

    public String getSynchFreq() {
        return this.synchFreq;
    }

    public void setSynchFreq(String synchFreq) {
        this.synchFreq = synchFreq;
    }

    public DataSource getSelectedDataSource() {
        return this.selectedDataSource;
    }

    public void setSelectedDataSource(DataSource selectedDataSource) {
        this.selectedDataSource = selectedDataSource;
    }

    public String getDataSourceDesc() {
        return this.dataSourceDesc;
    }

    public void setDataSourceDesc(String dataSourceDesc) {
        this.dataSourceDesc = dataSourceDesc;
    }

    public StringPairPropertySelectionModel getActiveDataSourceList() {
        return this.activeDataSourceList;
    }

    public void setActiveDataSourceList(StringPairPropertySelectionModel activeDataSourceList) {
        this.activeDataSourceList = activeDataSourceList;
    }

    public boolean isAllowedToSelectDataSource() {
        Collection allSpConnections = MgmtFactory.getConnectionManager().getAllSpConnections();
        if (this.selectedDataSourceOnPopulate != null && this.selectedDataSource != null && allSpConnections != null) {
            for (ConnectionBase connection : allSpConnections) {
                ProvisionerConfig provisionerConfig;
                if (!connection.isActive() || (provisionerConfig = (ProvisionerConfig)connection.getModuleConfiguration(ProvisionerConfig.class)) == null) continue;
                for (Channel channel : provisionerConfig.getChannels()) {
                    if (!channel.isActive()) continue;
                    return false;
                }
            }
        }
        return true;
    }
}

