/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.ChannelItem;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.SaaSChannelTasklet;
import com.pingidentity.fsm.tasklet.impl.SaaSManagementTasklet;
import com.pingidentity.provisioner.domain.Channel;
import com.pingidentity.provisioner.domain.ProvisionerGlobalSettings;
import com.pingidentity.provisioner.domain.mgmt.ProvisionerConfig;
import com.pingidentity.provisioner.domain.mgmt.ProvisionerManager;
import com.pingidentity.provisioner.domain.source.ChannelSource;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class SaaSManagementState
extends TaskletState {
    private static final long serialVersionUID = 20050515L;
    List<ChannelItem> channels = new ArrayList<ChannelItem>();
    private transient Object componentState;

    public SaaSManagementState(Tasklet value) {
        super((IWizard)value);
        this.setMenuName("Manage Channels");
    }

    public void populate(Object dataFromDisk) {
        SpConnection connection;
        ProvisionerConfig provConfig;
        this.channels.clear();
        if (dataFromDisk != null && (provConfig = (ProvisionerConfig)(connection = (SpConnection)dataFromDisk).getModuleConfiguration(ProvisionerConfig.class)) != null && provConfig.hasChannels() && !connection.isCopiedConnection()) {
            SaaSManagementTasklet saaSManagementTasklet = (SaaSManagementTasklet)this.getParent();
            for (Channel c : provConfig.getChannels()) {
                SaaSChannelTasklet t = (SaaSChannelTasklet)this.createTaskletToLoad(SaaSChannelTasklet.class, "SaaSChannelTasklet", "Channel");
                t.setFinishAvailable(this.isAuthorizedForAction());
                t.markProtocolImgAvailable(this.getParent().isProtocolImgAvailable());
                t.setMode(Mode.edit);
                t.populate(c);
                ChannelItem i = new ChannelItem(provConfig.getTarget(), t);
                this.channels.add(i);
            }
        }
    }

    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean failFast) {
        this.refreshChannelList();
        boolean oneChannelConfigured = false;
        for (ChannelItem channelItem : this.channels) {
            if (channelItem.isDeleted()) continue;
            oneChannelConfigured = true;
            break;
        }
        if (!oneChannelConfigured) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("One_channel_required"), ValidationConstraint.REQUIRED);
        }
    }

    public void create(IRequestCycle cycle) {
        if (this.isAuthorizedForAction()) {
            SaaSManagementTasklet saaSManagementTasklet = (SaaSManagementTasklet)this.getParent();
            SaaSChannelTasklet t = (SaaSChannelTasklet)this.createTaskletToLoad(SaaSChannelTasklet.class, "SaaSChannelTasklet", "Channel");
            t.setMode(Mode.create);
            t.markProtocolImgAvailable(true);
            t.setCycle(cycle);
            t.setFinishAvailable(true);
            this.setTaskletToEdit((Tasklet)t);
            this.loadTasklet((Tasklet)t);
        }
    }

    public boolean save(Object dataToDisk) {
        SpConnection connection = (SpConnection)dataToDisk;
        ProvisionerConfig provConfig = (ProvisionerConfig)connection.getModuleConfiguration(ProvisionerConfig.class);
        provConfig.setChannels(this.loadChannels());
        return true;
    }

    private List<Channel> loadChannels() {
        ArrayList<Channel> loadedChannels = new ArrayList<Channel>();
        for (ChannelItem channelItem : this.channels) {
            if (channelItem.isDeleted()) continue;
            SaaSChannelTasklet t = channelItem.getTasklet();
            Channel channel = new Channel();
            t.save(channel);
            loadedChannels.add(channel);
        }
        return loadedChannels;
    }

    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        for (ChannelItem i : this.channels) {
            summaryList.add(new SummaryInfo("Channel Name", i.getName(), (TaskletState)this));
        }
    }

    public void onResumeDraft() {
        for (ChannelItem c : this.channels) {
            SaaSChannelTasklet t = c.getTasklet();
            t.onResumeDraft();
        }
    }

    public void updateVisit(Visit freshVisit) {
        for (ChannelItem c : this.channels) {
            SaaSChannelTasklet t = c.getTasklet();
            t.updateVisit(freshVisit);
        }
    }

    public Object getComponentState() {
        return this.componentState;
    }

    public void setComponentState(Object componentState) {
        this.componentState = componentState;
    }

    public List<ChannelItem> getChannels() {
        this.refreshChannelList();
        return this.channels;
    }

    public void setChannels(List<ChannelItem> channels) {
        this.channels = channels;
    }

    public void refreshChannelList() {
        Tasklet t = this.getTaskletToEdit();
        if (t != null && !t.isCancelled()) {
            boolean exists = false;
            for (ChannelItem i : this.channels) {
                if (!((Object)((Object)i.getTasklet())).equals(t)) continue;
                exists = true;
            }
            if (!exists) {
                ChannelItem i = new ChannelItem((SaaSChannelTasklet)t);
                i.setNewChannel(true);
                this.channels.add(i);
            }
        }
        this.setTaskletToEditToNull();
    }

    private DataSource getDataSource() {
        ProvisionerGlobalSettings globalSettings = ProvisionerManager.getProvisionerGlobalSettings();
        String selectedDataSourceId = globalSettings.getInternalDataSourceId();
        if (selectedDataSourceId != null) {
            DataSourceManager dsMgr = MgmtFactory.getDataSourceManager();
            return dsMgr.getJdbcDataSource(selectedDataSourceId);
        }
        return null;
    }

    public String getSelectedDataSourceDesc() {
        DataSource ds = this.getDataSource();
        return ds != null ? ds.getDescription() : "None";
    }

    public String getDataSourceType() {
        DataSource ds = this.getDataSource();
        return ds != null ? ds.getDataSourceType() : "None";
    }

    public int getSynchFreq() {
        return ProvisionerManager.getProvisionerGlobalSettings().getSyncInterval();
    }

    public boolean doesChannelNameExist(String name, String channelId) {
        for (ChannelItem channelItem : this.channels) {
            if (channelItem.getChannelId().equals(channelId) || !channelItem.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public String getChannelSourcesForSummary() {
        String sourceSummary = null;
        ArrayList<ChannelSource> channelSourceList = new ArrayList<ChannelSource>();
        for (Channel channelItem : this.loadChannels()) {
            ChannelSource channelSource = channelItem.getSource();
            if (channelSourceList.contains(channelSource)) continue;
            channelSourceList.add(channelSource);
        }
        DataSourceManager dataSourceManager = MgmtFactory.getDataSourceManager();
        StringBuffer sb = new StringBuffer();
        Iterator sourceListIterator = channelSourceList.iterator();
        while (sourceListIterator.hasNext()) {
            String dataSourceId = ((ChannelSource)sourceListIterator.next()).getDataSourceId();
            DataSource dataSource = dataSourceManager.getDataSource(dataSourceId);
            if (dataSource == null) continue;
            sb.append(dataSource.getDsName());
            if (!sourceListIterator.hasNext()) continue;
            sb.append(", ");
        }
        sourceSummary = sb.toString();
        return sourceSummary;
    }

    public Set<String> getAllUniqueFieldNamesFromIdentityMappingFieldsInChannelTasklets() {
        HashSet<String> allUniqueFieldNamesFromAllIdentityMappingsInAllChannels = new HashSet<String>();
        for (ChannelItem channelItem : this.getChannels()) {
            allUniqueFieldNamesFromAllIdentityMappingsInAllChannels.addAll(channelItem.getTasklet().getCurrentIdentityMappingsFieldNames());
        }
        return allUniqueFieldNamesFromAllIdentityMappingsInAllChannels;
    }

    public void refreshAttributeMappingTasklets() {
        for (ChannelItem channelItem : this.getChannels()) {
            channelItem.getTasklet().refreshAttributeMappingTasklets();
        }
    }
}

