/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.common.util.OgnlHelper;
import com.pingidentity.fsm.state.impl.ConfigLdapDirSearchState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.impl.SaaSChannelTasklet;
import com.pingidentity.provisioner.domain.Channel;
import com.pingidentity.provisioner.domain.IdentityMappingField;
import com.pingidentity.provisioner.mapping.FieldConfig;
import com.pingidentity.provisioner.mapping.FieldInfo;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ognl.Ognl;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.apache.tapestry.valid.ValidationDelegate;
import org.sourceid.saml20.adapter.attribute.AttributeValue;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;

public class SaaSSelectAttrMappingState
extends ConfigLdapDirSearchState {
    private static final long serialVersionUID = 20050515L;
    private String idMappingFieldName;
    private FieldInfo fieldInfo;
    private String expression;
    private String defaultValue;
    private boolean createOnly;
    private boolean trim;
    private boolean mask;
    private IdentityMappingField.FIELD_CASE fieldCase;
    private IdentityMappingField.TRANSFORM_OPTION transformOptionSelection = IdentityMappingField.TRANSFORM_OPTION.NONE;
    private Object testResult;
    private boolean editMode;
    private String ognlToBeTested;
    private List<TestValue> selectedAttributesForTest = new ArrayList<TestValue>();
    private static IdentityMappingField.FIELD_CASE upperCase = IdentityMappingField.FIELD_CASE.UPPER;
    private static IdentityMappingField.FIELD_CASE lowerCase = IdentityMappingField.FIELD_CASE.LOWER;
    private static IdentityMappingField.FIELD_CASE noCase = IdentityMappingField.FIELD_CASE.NONE;
    private static final String ERROR_DURING_EXPRESSION_EVAL = "Error during expression evaluation: ";
    private static final String USER_NOT_AUTHORIZED = "User not authorized to test this expression.";
    private static final String TEST_SKIPPED = "Expression evaluation skipped: ";
    private static final String VALUE_REQUIRED = "Empty String";

    public SaaSSelectAttrMappingState(Tasklet value) {
        super(value);
        this.setMenuName("Specify Attribute Mapping");
    }

    public void populate(Object dataFromDisk) {
        if (dataFromDisk instanceof IdentityMappingField) {
            ArrayList selectedAttributesCopy;
            IdentityMappingField identityMappingField = (IdentityMappingField)dataFromDisk;
            this.idMappingFieldName = identityMappingField.getFieldName();
            this.fieldInfo = identityMappingField.getFieldInfo();
            this.expression = this.isExpressionsEnabled() ? identityMappingField.getFieldConfig().getScript() : "";
            this.defaultValue = identityMappingField.getFieldConfig().getDefault();
            this.createOnly = identityMappingField.getFieldConfig().isCreateOnly();
            this.trim = identityMappingField.getFieldConfig().isTrim();
            this.mask = identityMappingField.getFieldConfig().isMasked();
            this.fieldCase = identityMappingField.getFieldCase();
            this.transformOptionSelection = identityMappingField.getTransformOption();
            this.selectedAttributes = selectedAttributesCopy = new ArrayList(identityMappingField.getFieldConfig().getAttributeNames());
            SaaSChannelTasklet tasklet = (SaaSChannelTasklet)((Object)this.findParent(SaaSChannelTasklet.class));
            this.dataSource = (LdapDataSource)tasklet.getSelectedDataSource();
            this.populate();
        }
    }

    public void populate() {
        if (!this.isViewOnly() && this.dataSource != null) {
            this.initializeSearchScope();
            this.selectedRootClass = "";
            this.availableAttributes = this.getAvailableAttrs();
            this.cullAvailableAttributes();
            this.availableAttrList = this.createPairModel(this.availableAttributes);
        }
        if (StringUtils.isBlank((String)this.selectedAvailableAttr)) {
            this.selectedAvailableAttr = null;
        }
    }

    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (this.isRequiredAndUndefined()) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("Required_field_error"), ValidationConstraint.REQUIRED);
        }
        if (this.isExpRequiredAndUndefined()) {
            if (this.isExpressionsEnabled()) {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Expression_required"), ValidationConstraint.REQUIRED);
            } else {
                delegate.setFormComponent(null);
                delegate.record(this.getMessage("Expression_required_ognl_disabled"), ValidationConstraint.REQUIRED);
            }
        }
        if (!StringUtils.isBlank((String)this.expression)) {
            this.setupTest();
            this.wasTestSuccessful(this.selectedAttributesForTest);
        }
    }

    public boolean isRequiredAndUndefined() {
        return this.fieldInfo.isRequired() && this.selectedAttributes.size() == 0 && StringUtils.isBlank((String)this.defaultValue) && StringUtils.isBlank((String)this.expression);
    }

    public boolean isExpRequiredAndUndefined() {
        return !this.fieldInfo.isLdapMap() && this.selectedAttributes.size() > 1 && StringUtils.isBlank((String)this.expression);
    }

    public void onStateActivated() {
        SaaSChannelTasklet t = (SaaSChannelTasklet)((Object)this.findParent(SaaSChannelTasklet.class));
        if (t != null && t.getSelectedDataSource() != null) {
            LdapDataSource temp = (LdapDataSource)t.getSelectedDataSource();
            super.initDataSource(temp);
        }
        if (this.searchScopeList == null) {
            this.searchScopeList = new StringPairPropertySelectionModel();
        }
        if (this.rootObjClassList == null) {
            this.rootObjClassList = new StringPairPropertySelectionModel();
        }
        if (this.availableAttrList == null) {
            this.availableAttrList = new StringPairPropertySelectionModel();
        }
        this.editMode = false;
    }

    public boolean save(Object dataToDisk) {
        IdentityMappingField identityMappingField = this.createIdentityMappingField();
        Channel channel = (Channel)dataToDisk;
        channel.getIdentityMapping().add(identityMappingField);
        return true;
    }

    public IdentityMappingField createIdentityMappingField() {
        FieldConfig fieldConfig = new FieldConfig();
        fieldConfig.addAttributeNames((Collection)this.selectedAttributes);
        fieldConfig.setDefault(this.defaultValue);
        fieldConfig.setScript(this.expression);
        fieldConfig.setCreateOnly(this.createOnly);
        fieldConfig.setTrim(this.trim);
        fieldConfig.setMasked(this.mask);
        if (this.fieldCase.equals((Object)IdentityMappingField.FIELD_CASE.LOWER)) {
            fieldConfig.setToLower(true);
            fieldConfig.setToUpper(false);
        } else if (this.fieldCase.equals((Object)IdentityMappingField.FIELD_CASE.UPPER)) {
            fieldConfig.setToLower(false);
            fieldConfig.setToUpper(true);
        } else {
            fieldConfig.setToLower(false);
            fieldConfig.setToUpper(false);
        }
        if (IdentityMappingField.TRANSFORM_OPTION.EXTRACT_CN_FROM_DN.equals((Object)this.transformOptionSelection)) {
            fieldConfig.setExtractCnFromDn(true);
        } else if (IdentityMappingField.TRANSFORM_OPTION.EXTRACT_USERNAME_FROM_EMAIL.equals((Object)this.transformOptionSelection)) {
            fieldConfig.setExtractUserNameFromEmail(true);
        }
        IdentityMappingField identityMappingField = new IdentityMappingField(this.idMappingFieldName);
        identityMappingField.setFieldConfig(fieldConfig);
        identityMappingField.setFieldInfo(this.fieldInfo);
        return identityMappingField;
    }

    public StringPairPropertySelectionModel getDefaultOptionsList() {
        ArrayList<String> optionLabels = new ArrayList<String>();
        for (FieldInfo.Option option : this.fieldInfo.getOptions()) {
            optionLabels.add(option.getLabel());
        }
        String[] optionLabelsArray = optionLabels.toArray(new String[optionLabels.size()]);
        return new StringPairPropertySelectionModel(true, optionLabelsArray);
    }

    public void onUpdateItem(IRequestCycle cycle) {
        if (this.wasTestSuccessful(this.selectedAttributesForTest)) {
            this.expression = this.ognlToBeTested;
            this.editMode = false;
        }
    }

    public boolean testData() {
        return this.wasTestSuccessful(this.selectedAttributesForTest);
    }

    private boolean isExpressionTestable(String expression, ValidationDelegate delegate) {
        ExpressionManager expressionManager = ExpressionManager.getInstance();
        if (!expressionManager.isEvaluateExpressionsOn()) {
            String msg = "Error during expression evaluation: User not authorized to test this expression.";
            this.log.debug((Object)msg);
            if (delegate != null) {
                delegate.record(msg, ValidationConstraint.REQUIRED);
                delegate.setFormComponent(null);
            }
            return false;
        }
        if (StringUtils.isEmpty((String)expression)) {
            String msg = "Expression evaluation skipped: Empty String";
            this.log.debug((Object)msg);
            if (delegate != null) {
                delegate.record(msg, ValidationConstraint.REQUIRED);
                delegate.setFormComponent(null);
            }
            return false;
        }
        return true;
    }

    private boolean wasTestSuccessful(List<TestValue> attrsToTest) {
        ValidationDelegate delegate = this.getDelegate();
        this.setTestResult(null);
        if (!this.isExpressionTestable(this.ognlToBeTested, delegate)) {
            return false;
        }
        try {
            Object parsedExpression = Ognl.parseExpression((String)this.ognlToBeTested);
            OgnlHelper ognlHelper = new OgnlHelper();
            ognlHelper.searchForAllVariableNames(parsedExpression);
            HashMap<String, String> substitutionValues = new HashMap<String, String>();
            for (TestValue t : attrsToTest) {
                substitutionValues.put(t.getAttribute(), t.getValue());
            }
            String invalidSubstitution = ognlHelper.containsInvalidSubstitutions(substitutionValues);
            if (invalidSubstitution != null) {
                String msg = ERROR_DURING_EXPRESSION_EVAL + this.getMessage("Invalid_column", new Object[]{invalidSubstitution});
                this.log.debug((Object)msg);
                if (delegate != null) {
                    delegate.record(msg, ValidationConstraint.REQUIRED);
                    delegate.setFormComponent(null);
                }
                return false;
            }
            HashMap<String, AttributeValue> testDataMap = new HashMap<String, AttributeValue>();
            for (Map.Entry item : substitutionValues.entrySet()) {
                testDataMap.put((String)item.getKey(), new AttributeValue((String)item.getValue()));
            }
            Object results = ognlHelper.processOgnlExpression(parsedExpression, testDataMap, testDataMap);
            this.setTestResult(results);
        }
        catch (Exception e) {
            this.log.debug((Object)("Test of OGNL expression" + this.ognlToBeTested + " failed."), (Throwable)e);
            if (delegate != null) {
                delegate.record(ERROR_DURING_EXPRESSION_EVAL + e.getLocalizedMessage(), ValidationConstraint.REQUIRED);
                delegate.setFormComponent(null);
            }
            return false;
        }
        return true;
    }

    public void setupTest() {
        ArrayList<TestValue> temp = new ArrayList<TestValue>();
        for (String attr : this.selectedAttributes) {
            if (this.wasCached(attr, temp)) continue;
            TestValue v = new TestValue();
            v.setAttribute(attr);
            v.setValue("");
            temp.add(v);
        }
        this.selectedAttributesForTest = temp;
        this.ognlToBeTested = this.expression;
        this.testResult = "";
    }

    private boolean wasCached(String attr, List<TestValue> temp) {
        for (TestValue v : this.selectedAttributesForTest) {
            if (!attr.equals(v.getAttribute())) continue;
            temp.add(v);
            return true;
        }
        return false;
    }

    public boolean isDisplayMinLength() {
        return this.fieldInfo.getMinLength() > 0;
    }

    public boolean isDisplayMaxLength() {
        return this.fieldInfo.getMaxLength() < Integer.MAX_VALUE;
    }

    public boolean isDisplayPattern() {
        return !StringUtils.isBlank((String)this.fieldInfo.getRegEx());
    }

    public boolean isDisplayNotes() {
        return this.fieldInfo.getNotes() != null && this.fieldInfo.getNotes().size() > 0;
    }

    public String getExpression() {
        return this.expression;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setExpression(String expression) {
        if (this.isEaAdmin()) {
            this.expression = expression;
        }
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean isCreateOnly() {
        return this.createOnly;
    }

    public void setCreateOnly(boolean createOnly) {
        this.createOnly = createOnly;
    }

    public boolean isTrim() {
        return this.trim;
    }

    public void setTrim(boolean trim) {
        this.trim = trim;
    }

    public IdentityMappingField.FIELD_CASE getFieldCase() {
        return this.fieldCase;
    }

    public void setFieldCase(IdentityMappingField.FIELD_CASE fieldCase) {
        this.fieldCase = fieldCase;
    }

    public static IdentityMappingField.FIELD_CASE getUpperCase() {
        return upperCase;
    }

    public static void setUpperCase(IdentityMappingField.FIELD_CASE upperCase) {
        SaaSSelectAttrMappingState.upperCase = upperCase;
    }

    public static IdentityMappingField.FIELD_CASE getLowerCase() {
        return lowerCase;
    }

    public static void setLowerCase(IdentityMappingField.FIELD_CASE lowerCase) {
        SaaSSelectAttrMappingState.lowerCase = lowerCase;
    }

    public static IdentityMappingField.FIELD_CASE getNoCase() {
        return noCase;
    }

    public static void setNoCase(IdentityMappingField.FIELD_CASE noCase) {
        SaaSSelectAttrMappingState.noCase = noCase;
    }

    public FieldInfo getFieldInfo() {
        return this.fieldInfo;
    }

    public String getSelectedDefaultValue() {
        for (FieldInfo.Option option : this.fieldInfo.getOptions()) {
            if (!option.getCode().equals(this.defaultValue)) continue;
            return option.getLabel();
        }
        return null;
    }

    public void setSelectedDefaultValue(String selectedDefaultValue) {
        for (FieldInfo.Option option : this.fieldInfo.getOptions()) {
            if (!option.getLabel().equals(selectedDefaultValue)) continue;
            this.defaultValue = option.getCode();
            return;
        }
        this.defaultValue = "";
    }

    public String getDefaultValueForDisplay() {
        if (this.fieldInfo.hasOptions() && !StringUtils.isBlank((String)this.defaultValue)) {
            return this.getSelectedDefaultValue();
        }
        return this.defaultValue;
    }

    public boolean isExpressionsEnabled() {
        ExpressionManager expressionManager = ExpressionManager.getInstance();
        return expressionManager.isEvaluateExpressionsOn();
    }

    public List<String> getAvailableAttributes() {
        return this.getAvailableAttrs();
    }

    public Object getTestResult() {
        return this.testResult;
    }

    public void setTestResult(Object testResult) {
        this.testResult = testResult;
    }

    public boolean isEditMode() {
        return this.editMode;
    }

    public void setEditMode(boolean editMode) {
        this.editMode = editMode;
    }

    public String getOgnlToBeTested() {
        return this.ognlToBeTested;
    }

    public void setOgnlToBeTested(String ognlToBeTested) {
        this.ognlToBeTested = ognlToBeTested;
    }

    public List<TestValue> getSelectedAttributesForTest() {
        return this.selectedAttributesForTest;
    }

    public void setSelectedAttributesForTest(List<TestValue> selectedAttributesForTest) {
        this.selectedAttributesForTest = selectedAttributesForTest;
    }

    public IdentityMappingField.TRANSFORM_OPTION getExtractCnFromDn() {
        return IdentityMappingField.TRANSFORM_OPTION.EXTRACT_CN_FROM_DN;
    }

    public IdentityMappingField.TRANSFORM_OPTION getExtractEmail() {
        return IdentityMappingField.TRANSFORM_OPTION.EXTRACT_USERNAME_FROM_EMAIL;
    }

    public IdentityMappingField.TRANSFORM_OPTION getTransformOptionSelection() {
        return this.transformOptionSelection;
    }

    public void setTransformOptionSelection(IdentityMappingField.TRANSFORM_OPTION transformOptionSelection) {
        this.transformOptionSelection = transformOptionSelection;
    }

    public StringPairPropertySelectionModel getTransformOptionsList() {
        StringPairPropertySelectionModel model = new StringPairPropertySelectionModel();
        model.add("None", (Object)IdentityMappingField.TRANSFORM_OPTION.NONE);
        model.add("Extract CN from DN", (Object)IdentityMappingField.TRANSFORM_OPTION.EXTRACT_CN_FROM_DN);
        model.add("Extract Username from Email", (Object)IdentityMappingField.TRANSFORM_OPTION.EXTRACT_USERNAME_FROM_EMAIL);
        return model;
    }

    public boolean isMask() {
        return this.mask;
    }

    public void setMask(boolean mask) {
        this.mask = mask;
    }

    public boolean isEaAdmin() {
        AdministrativeUser adminUser = this.getCurrentUser();
        return adminUser.isExpressionAdmin();
    }

    protected boolean isAttributeOptionsSupported() {
        return false;
    }

    public static class TestValue {
        private String attribute;
        private String value;

        public String getAttribute() {
            return this.attribute;
        }

        public void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

