/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.SelectDataSourceState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.SaaSChannelTasklet;
import com.pingidentity.provisioner.domain.Channel;
import java.util.ArrayList;
import java.util.List;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.datasource.info.LdapInfo;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class SaaSSourceSelectionState
extends SelectDataSourceState {
    private static final long serialVersionUID = 1L;
    private boolean stateChanged;
    private boolean selectedDataSourceReachable;
    private String dataSourceIdFromDisk;
    private String prevSelectedDataSourceId;
    private String ldapTypeFromDisk;

    public SaaSSourceSelectionState(Tasklet value, String name) {
        super(value, name);
        this.setMenuName("Source");
    }

    protected List<DataSource> loadDataSources() {
        DataSourceManager dataMgr = MgmtFactory.getDataSourceManager();
        ArrayList<DataSource> dataSources = new ArrayList<DataSource>();
        for (LdapDataSource ldapSource : dataMgr.getLdapDataSources()) {
            if (ldapSource.getLdapType() == null || LdapInfo.LdapType.Undefined.equals((Object)ldapSource.getLdapType())) continue;
            dataSources.add((DataSource)ldapSource);
        }
        return dataSources;
    }

    public void populate(Object dataFromDisk) {
        if (dataFromDisk instanceof Channel) {
            Channel channel = (Channel)dataFromDisk;
            this.prevSelectedDataSourceId = this.dataSourceIdFromDisk = channel.getSource().getDataSourceId();
            this.selectedDataSourceId = this.dataSourceIdFromDisk;
            this.selectedDataSource = MgmtFactory.getDataSourceManager().getLdapDataSource(this.selectedDataSourceId);
            this.ldapTypeFromDisk = ((LdapDataSource)this.selectedDataSource).getLdapType().name();
        }
        this.populate();
    }

    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        if (this.selectedDataSource == null) {
            delegate.record(this.getMessage("Data_store_required"), ValidationConstraint.REQUIRED);
        }
    }

    public boolean save(Object dataToDisk) {
        Channel channel = (Channel)dataToDisk;
        channel.getSource().setDataSourceId(this.selectedDataSourceId);
        return true;
    }

    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        summaryList.add(new SummaryInfo("Active Data Store", this.getSelectedDataSource().getDescription(), (TaskletState)this));
        summaryList.add(new SummaryInfo("Data Store Type", this.getSelectedDataSource().getDataSourceType(), (TaskletState)this));
    }

    public void formListener(IRequestCycle cycle) {
        super.formListener(cycle);
        if (!(this.stateChanged || this.selectedDataSourceId == null || this.selectedDataSourceId.equals(this.dataSourceIdFromDisk) && this.getSelectedLdapType().equals(this.ldapTypeFromDisk))) {
            this.stateChanged = true;
        }
        if (this.selectedDataSourceId != null && !this.selectedDataSourceId.equals(this.prevSelectedDataSourceId)) {
            this.recordDataStoreAvailability();
            this.prevSelectedDataSourceId = this.selectedDataSourceId;
            this.handleParentTaskletSetStateMode();
        }
    }

    private void handleParentTaskletSetStateMode() {
        Visit v;
        SaaSChannelTasklet parentSaaSChannelTasklet;
        Tasklet tasklet = this.getParent();
        if (tasklet != null && tasklet instanceof SaaSChannelTasklet && (parentSaaSChannelTasklet = (SaaSChannelTasklet)tasklet).showSaveAll() && !(v = parentSaaSChannelTasklet.getSystemVisit()).isSkipForUIPerformanceFlag()) {
            if (this.selectedDataSourceReachable) {
                parentSaaSChannelTasklet.setStatesToEditMode(this.selectedDataSource);
            } else {
                parentSaaSChannelTasklet.setStatesToVOMode(this.selectedDataSource);
            }
        }
    }

    public String getSelectedLdapType() {
        DataSourceManager dataMgr = MgmtFactory.getDataSourceManager();
        LdapDataSource ldap = dataMgr.getLdapDataSource(this.selectedDataSourceId);
        return ldap.getLdapType().name();
    }

    public String getSelectedLdapTypeForDisplay() {
        if (this.getSelectedDataSource() instanceof LdapDataSource) {
            LdapDataSource s = (LdapDataSource)this.getSelectedDataSource();
            return s.getLdapTypeDesc();
        }
        return "";
    }

    public boolean isStateChanged() {
        return this.stateChanged;
    }

    public String getSelectedDataSourceId() {
        return this.selectedDataSourceId;
    }

    public void reset() {
    }

    public void setStateChanged(boolean stateChanged) {
        this.stateChanged = stateChanged;
    }

    public boolean isAllowedToSelectActiveDataStore() {
        SaaSChannelTasklet saasChannelTasklet = (SaaSChannelTasklet)this.getParent();
        return saasChannelTasklet.isNewChannel() || !saasChannelTasklet.isChannelActiveFromDisk() || !saasChannelTasklet.isConnectionActiveFromDisk();
    }

    private void recordDataStoreAvailability() {
        SaaSChannelTasklet saasChannelTasklet = (SaaSChannelTasklet)this.getParent();
        this.selectedDataSourceReachable = saasChannelTasklet.isDataStoreAvailable(this.selectedDataSource);
    }

    public boolean isSelectedDataSourceReachable() {
        return this.selectedDataSourceReachable;
    }

    public void setSelectedDataSourceReachable(boolean selectedDataSourceReachable) {
        this.selectedDataSourceReachable = selectedDataSourceReachable;
    }

    public String getDataSourceUnavailableMessage() {
        return this.getMessage("Data_store_unavailable");
    }

    public boolean onStateExit() {
        super.handleOnStateExit(false);
        return true;
    }
}

