/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.state.impl;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.FieldItem;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.SaaSManagementTasklet;
import com.pingidentity.provisioner.domain.mgmt.ProvisionerConfig;
import com.pingidentity.provisioner.domain.target.SaasTarget;
import com.pingidentity.provisioner.saas.BaseSaasPlugin;
import com.pingidentity.provisioner.saas.SaasException;
import com.pingidentity.provisioner.saas.SaasPluginManager;
import com.pingidentity.provisioner.saas.SaasProvisionerPlugin;
import com.pingidentity.provisioner.validation.SaasParametersValidator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.conf.FieldList;
import org.sourceid.saml20.adapter.conf.SimpleFieldList;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.adapter.gui.validation.ValidationException;
import org.sourceid.saml20.domain.SpConnection;

public class SaaSTargetState
extends TaskletState {
    private static final long serialVersionUID = 2L;
    private String pluginId;
    private List<FieldItem> targetParameters = new ArrayList<FieldItem>();
    private List<FieldItem> originalTargetParameters;
    private boolean triggerAppendErrors;

    public SaaSTargetState(IWizard owner) {
        super(owner);
        this.setMenuName("Target");
    }

    public void populate(Object dataFromDisk) {
        if (dataFromDisk instanceof SpConnection) {
            SpConnection connection = (SpConnection)dataFromDisk;
            ProvisionerConfig provConfig = (ProvisionerConfig)connection.getModuleConfiguration(ProvisionerConfig.class);
            this.pluginId = provConfig.getType();
            SaasPluginManager pluginManager = SaasPluginManager.getInstance();
            SaasProvisionerPlugin saasProvisioningPlugin = pluginManager.getPluginInstance(this.pluginId);
            if (saasProvisioningPlugin != null) {
                if (!connection.isCopiedConnection() && provConfig.getTarget() != null) {
                    SaasTarget target = provConfig.getTarget();
                    SimpleFieldList parameterValues = target.getParameterValues();
                    List guiFieldDescriptors = saasProvisioningPlugin.getConfiguredParameterDescriptors((FieldList)parameterValues);
                    this.targetParameters = this.buildFieldItems(guiFieldDescriptors);
                    this.originalTargetParameters = this.buildFieldItems(guiFieldDescriptors);
                    this.populateTargetParameters(parameterValues, this.targetParameters);
                    this.populateTargetParameters(parameterValues, this.originalTargetParameters);
                } else {
                    List fieldDescriptors = saasProvisioningPlugin.getParameterDescriptors();
                    this.targetParameters = this.buildFieldItems(fieldDescriptors);
                    this.originalTargetParameters = this.buildFieldItems(fieldDescriptors);
                }
            }
        }
    }

    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean failFast) {
        List<String> errorMessages = this.validateTargetParameters();
        for (String errorMessage : errorMessages) {
            delegate.setFormComponent(null);
            delegate.record(errorMessage, ValidationConstraint.REQUIRED);
        }
        if (this.allowTestConnection(delegate)) {
            try {
                SaasTarget saasTarget = this.getSaasTarget();
                if (!saasTarget.testConnection()) {
                    delegate.setFormComponent(null);
                    delegate.record(this.getMessage("SaasTarget_test_connection_failed_connection"), ValidationConstraint.REQUIRED);
                    this.log.error((Object)this.getMessage("SaasTarget_test_connection_failed_forlog"));
                }
            }
            catch (SaasException e) {
                delegate.setFormComponent(null);
                delegate.clearErrors();
                delegate.record(this.getMessage("SaasTarget_test_connection_failed"), ValidationConstraint.REQUIRED);
                this.log.error((Object)(this.getMessage("SaasTarget_test_connection_failed_forlog") + " " + e.getMessage()), (Throwable)e);
            }
            if (this.triggerAppendErrors && !delegate.getHasErrors()) {
                this.triggerAppendErrors = false;
            }
        }
    }

    private boolean allowTestConnection(IValidationDelegate errDelegate) {
        SaasProvisionerPlugin saasProvisioningPlugin = SaasPluginManager.getInstance().getPluginInstance(this.pluginId);
        if (saasProvisioningPlugin instanceof BaseSaasPlugin && !((BaseSaasPlugin)saasProvisioningPlugin).isTestConnectionSupported()) {
            return false;
        }
        boolean allowTestConnection = false;
        if (!errDelegate.getHasErrors() && (this.triggerAppendErrors || this.isTargetParametersChanged())) {
            allowTestConnection = true;
        }
        return allowTestConnection;
    }

    public boolean save(Object dataToDisk) {
        SpConnection connection = (SpConnection)dataToDisk;
        ProvisionerConfig provConfig = (ProvisionerConfig)connection.getModuleConfiguration(ProvisionerConfig.class);
        provConfig.setEntityId(((SaaSManagementTasklet)((Object)this.findParent(SaaSManagementTasklet.class))).getConnId());
        provConfig.setTarget(this.getSaasTarget());
        provConfig.setType(this.pluginId);
        return true;
    }

    public void doSummary(ArrayList<SummaryInfo> summaryList) {
        if (this.targetParameters != null && !this.targetParameters.isEmpty()) {
            for (FieldItem parameter : this.targetParameters) {
                if (parameter.isEncrypted()) continue;
                summaryList.add(new SummaryInfo(parameter.getFieldDescriptor().getDescription(), parameter.toString(), (TaskletState)this));
            }
        } else {
            summaryList.add(new SummaryInfo(this.getMessage("Not_available"), this.getMessage("Not_available"), (TaskletState)this));
        }
    }

    public boolean isTargetSet() {
        if (this.targetParameters == null) {
            return false;
        }
        List<String> errorMessages = this.validateTargetParameters();
        return errorMessages.isEmpty();
    }

    public SaasTarget getSaasTarget() {
        SimpleFieldList parameterValues = this.buildSimpleFieldList(this.targetParameters);
        return new SaasTarget(this.pluginId, parameterValues);
    }

    public boolean showValues() {
        return !this.targetParameters.isEmpty();
    }

    public List<FieldItem> getTargetParameters() {
        return this.targetParameters;
    }

    public String getNotAvailableDesc() {
        return this.getMessage("Not_available");
    }

    public String getTargetDescription() {
        SaasPluginManager saasPluginManager = SaasPluginManager.getInstance();
        SaasProvisionerPlugin saasPlugin = saasPluginManager.getPluginInstance(this.pluginId);
        if (saasPlugin != null) {
            return saasPlugin.getDescription();
        }
        this.log.error((Object)("Saas Plugin not found (" + this.pluginId + ")"));
        return "";
    }

    private SimpleFieldList buildSimpleFieldList(List<FieldItem> parameters) {
        ArrayList<Field> fields = new ArrayList<Field>();
        if (parameters != null) {
            for (FieldItem fieldItem : parameters) {
                FieldDescriptor fieldDescriptor = fieldItem.getFieldDescriptor();
                Field field = new Field(fieldDescriptor.getName(), fieldDescriptor.getLabel(), fieldItem.getValue());
                fields.add(field);
            }
        }
        return new SimpleFieldList(fields);
    }

    private List<FieldItem> buildFieldItems(List<FieldDescriptor> fieldDescriptors) {
        ArrayList<FieldItem> fieldItems = new ArrayList<FieldItem>();
        if (fieldDescriptors != null) {
            for (FieldDescriptor fieldDescriptor : fieldDescriptors) {
                if (fieldDescriptor.isHidden()) continue;
                FieldItem fieldItem = new FieldItem(fieldDescriptor);
                fieldItem.setValue(fieldDescriptor.getDefaultValue());
                fieldItems.add(fieldItem);
            }
        }
        return fieldItems;
    }

    public void clearFieldValue(String fieldName) {
        int index = 0;
        for (FieldItem item : this.targetParameters) {
            if (fieldName.equals(item.getFieldDescriptor().getName())) {
                FieldItem fieldWithoutValue = new FieldItem(item.getFieldDescriptor());
                fieldWithoutValue.setAdvanced(item.isAdvanced());
                this.targetParameters.set(index, fieldWithoutValue);
                break;
            }
            ++index;
        }
    }

    public void clearSelectionFilterValue(String fieldName) {
        int index = 0;
        for (FieldItem item : this.targetParameters) {
            if (fieldName.equals(item.getFieldDescriptor().getName())) {
                FieldItem fieldWithoutValue = new FieldItem(item.getFieldDescriptor());
                fieldWithoutValue.setAdvanced(item.isAdvanced());
                this.targetParameters.set(index, fieldWithoutValue);
                break;
            }
            ++index;
        }
    }

    private List<String> validateTargetParameters() {
        ArrayList<String> errorMessages = new ArrayList<String>();
        if (this.targetParameters != null) {
            SaasProvisionerPlugin saasProvisioningPlugin;
            for (FieldItem parameterItem : this.targetParameters) {
                List validationChain = parameterItem.getFieldDescriptor().getValidationChain();
                if (validationChain == null) continue;
                for (FieldDescriptor.FieldValidationWrapper validator : validationChain) {
                    FieldDescriptor fieldDescriptor = parameterItem.getFieldDescriptor();
                    String fieldName = fieldDescriptor.getName();
                    try {
                        Field field = new Field(fieldName, fieldDescriptor.getLabel(), parameterItem.getValue());
                        if (validator.isSkipIfValueIsEmpty() && StringUtils.isBlank((String)field.getValue())) continue;
                        validator.getValidator().validate(field);
                    }
                    catch (ValidationException e) {
                        ArrayList<String> exceptionMessagesForDisplay = new ArrayList<String>();
                        List validationExceptionMessages = e.getErrorMessages();
                        for (String validationExceptionMessage : validationExceptionMessages) {
                            if (validationExceptionMessage.contains(fieldName)) {
                                String fieldDescription = parameterItem.getFieldDescriptor().getDescription();
                                validationExceptionMessage = validationExceptionMessage.replace(fieldName, fieldDescription);
                            }
                            exceptionMessagesForDisplay.add(validationExceptionMessage);
                        }
                        errorMessages.addAll(exceptionMessagesForDisplay);
                    }
                }
            }
            if (errorMessages.isEmpty() && (saasProvisioningPlugin = SaasPluginManager.getInstance().getPluginInstance(this.pluginId)) != null) {
                SimpleFieldList targetSimpleFieldList = this.buildSimpleFieldList(this.targetParameters);
                for (SaasParametersValidator saasParametersValidator : saasProvisioningPlugin.getSaasParametersValidators()) {
                    try {
                        saasParametersValidator.validate(targetSimpleFieldList);
                    }
                    catch (ValidationException e) {
                        errorMessages.addAll(e.getErrorMessages());
                        break;
                    }
                }
            }
        }
        return errorMessages;
    }

    private void populateTargetParameters(SimpleFieldList parameterValues, List<FieldItem> parameters) {
        for (FieldItem fieldItem : parameters) {
            if (fieldItem.getFieldDescriptor().isHidden()) continue;
            String fieldName = fieldItem.getFieldDescriptor().getName();
            String fieldValue = fieldItem.getValue();
            if (parameterValues.getField(fieldName) != null) {
                fieldValue = parameterValues.getFieldValue(fieldName);
            }
            fieldItem.setValue(fieldValue);
        }
    }

    private boolean isTargetParametersChanged() {
        SimpleFieldList originalParmsList = this.buildSimpleFieldList(this.originalTargetParameters);
        if (this.targetParameters != null) {
            for (FieldItem parameterItem : this.targetParameters) {
                String fieldName = parameterItem.getFieldDescriptor().getName();
                String originalValue = originalParmsList.getFieldValue(fieldName);
                String currentValue = parameterItem.getValue();
                if (currentValue != null && currentValue.equals(originalValue)) continue;
                return true;
            }
        }
        return false;
    }

    public void setTriggerAppendErrors(boolean triggerAppendErrors) {
        this.triggerAppendErrors = triggerAppendErrors;
    }

    public void onResumeDraft() {
        this.log = LogFactory.getLog(((Object)((Object)this)).getClass());
        SaasPluginManager pluginManager = SaasPluginManager.getInstance();
        SaasProvisionerPlugin saasProvisioningPlugin = pluginManager.getPluginInstance(this.pluginId);
        List<FieldItem> newTargetParameters = new ArrayList<FieldItem>();
        if (saasProvisioningPlugin != null) {
            List fieldDescriptors = saasProvisioningPlugin.getParameterDescriptors();
            if (fieldDescriptors.size() != this.targetParameters.size()) {
                newTargetParameters = this.buildFieldItems(fieldDescriptors);
            } else {
                Iterator descIterator = fieldDescriptors.iterator();
                for (FieldItem oldItem : this.targetParameters) {
                    FieldDescriptor newDescriptor = (FieldDescriptor)descIterator.next();
                    FieldItem newItem = new FieldItem(newDescriptor, oldItem);
                    newTargetParameters.add(newItem);
                }
            }
        }
        this.targetParameters = newTargetParameters;
        this.originalTargetParameters = null;
    }
}

