/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.data;

import com.pingidentity.fsm.state.impl.SaaSProvisioningState;
import com.pingidentity.fsm.tasklet.impl.SaaSChannelTasklet;
import com.pingidentity.fsm.tasklet.impl.SpConnectionConfigTasklet;
import com.pingidentity.provisioner.domain.target.SaasTarget;
import java.io.Serializable;
import java.util.Comparator;

public class ChannelItem
implements Serializable {
    private static final long serialVersionUID = 20050515L;
    private String target;
    private boolean deleted = false;
    private boolean newChannel = false;
    private SaaSChannelTasklet tasklet;
    public static final Comparator<ChannelItem> COMPARE_BY_NAME_UP = new Comparator<ChannelItem>(){

        @Override
        public int compare(ChannelItem chan1, ChannelItem chan2) {
            return chan1.getName().compareTo(chan2.getName()) * -1;
        }
    };
    public static final Comparator<ChannelItem> COMPARE_BY_NAME_DOWN = new Comparator<ChannelItem>(){

        @Override
        public int compare(ChannelItem chan1, ChannelItem chan2) {
            return chan1.getName().compareTo(chan2.getName());
        }
    };

    public ChannelItem(SaasTarget saasTarget, SaaSChannelTasklet tasklet) {
        if (saasTarget != null) {
            this.target = ((SpConnectionConfigTasklet)tasklet.findParent(SpConnectionConfigTasklet.class)).getSelectedConnectionModuleType(SaaSProvisioningState.class);
        }
        this.tasklet = tasklet;
    }

    public ChannelItem(SaaSChannelTasklet tasklet) {
        this.target = ((SpConnectionConfigTasklet)tasklet.findParent(SpConnectionConfigTasklet.class)).getSelectedConnectionModuleType(SaaSProvisioningState.class);
        this.tasklet = tasklet;
    }

    public String getName() {
        return this.tasklet.getName();
    }

    public String getChannelId() {
        return this.tasklet.getChannelId();
    }

    public String getSource() {
        return this.tasklet.getSelectedDataSourceId();
    }

    public String getTarget() {
        return this.target;
    }

    public String getChannelStatusDesc() {
        return this.tasklet.getChannelStatusDesc();
    }

    public SaaSChannelTasklet getTasklet() {
        return this.tasklet;
    }

    public String getClassType() {
        return this.isDeleted() ? "disabled" : "plain";
    }

    public String getActionClassType() {
        return this.isDisabled() ? "disabled" : "plain";
    }

    public boolean isActive() {
        return this.tasklet.isConnectionActive() && this.tasklet.isChannelActive();
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public boolean isDisabled() {
        return !this.tasklet.isAuthorizedForAction();
    }

    public boolean isNewChannel() {
        return this.newChannel;
    }

    public void setNewChannel(boolean newChannel) {
        this.newChannel = newChannel;
    }
}

