/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.sdk;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SaasUserData {
    private Map<String, List<String>> attributeMap;
    private Map<String, Map<String, List<String>>> mapAttributesMap;
    private Set<String> maskedFields = Collections.emptySet();
    private boolean accountEnabled = true;
    private String saasUserGuid;
    private String internalGuid;

    public SaasUserData(String saasUserGuid) {
        this.attributeMap = new HashMap<String, List<String>>();
        this.mapAttributesMap = new HashMap<String, Map<String, List<String>>>();
        this.saasUserGuid = saasUserGuid;
    }

    public String getSaasUserGuid() {
        return this.saasUserGuid;
    }

    public String getInternalGuid() {
        return this.internalGuid;
    }

    public void setInternalGuid(String internalGuid) {
        this.internalGuid = internalGuid;
    }

    public Map<String, List<String>> getAttributeMap() {
        return this.attributeMap;
    }

    public void setAttributeMap(Map<String, List<String>> attributeMap) {
        this.attributeMap = attributeMap;
    }

    public Map<String, Map<String, List<String>>> getMapAttributesMap() {
        return this.mapAttributesMap;
    }

    public boolean isAccountEnabled() {
        return this.accountEnabled;
    }

    public void setAccountEnabled(boolean accountEnabled) {
        this.accountEnabled = accountEnabled;
    }

    public void addAttribute(String name, String value) {
        ArrayList<String> valueList = new ArrayList<String>();
        valueList.add(value);
        this.attributeMap.put(name, valueList);
    }

    public void addAttribute(String name, Collection<String> valueColl) {
        if (valueColl != null && valueColl.size() > 0) {
            ArrayList<String> values = new ArrayList<String>();
            values.addAll(valueColl);
            this.attributeMap.put(name, values);
        }
    }

    public String getAttributeFirstValue(String name) {
        String firstValue = null;
        List<String> values = this.attributeMap.get(name);
        if (values != null && values.size() > 0) {
            firstValue = values.get(0);
        }
        return firstValue;
    }

    public List<String> getAttributeValues(String name) {
        return this.attributeMap.get(name);
    }

    public String toString() {
        String printStr = "\taccountEnabled = " + this.accountEnabled;
        if (this.attributeMap != null) {
            for (String key : this.attributeMap.keySet()) {
                printStr = printStr + "\n\t" + key + " = " + this.attributeMap.get(key);
            }
        }
        return printStr;
    }

    public Set<String> getMaskedFields() {
        return this.maskedFields;
    }

    public void setMaskedFields(Set<String> maskedFields) {
        this.maskedFields = maskedFields;
    }
}

