/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.sdk.internal;

import com.pingidentity.module.connection.ConnectionModuleConfiguration;
import com.pingidentity.provisioner.domain.mgmt.ProvisionerConfig;
import com.pingidentity.provisioner.domain.mgmt.ProvisionerManager;
import com.pingidentity.provisioner.identity.SaasIdentity;
import com.pingidentity.provisioner.saas.BaseSaasPlugin;
import com.pingidentity.provisioner.saas.SaasException;
import com.pingidentity.provisioner.sdk.SaasPluginException;
import com.pingidentity.provisioner.sdk.SaasPluginFieldInfo;
import com.pingidentity.provisioner.sdk.SaasUserData;
import com.pingidentity.provisioner.store.UserUpdater;
import com.pingidentity.provisioner.util.UserActivityLogger;
import com.pingidentity.templates.connection.ConnectionTemplate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.conf.SimpleFieldList;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.EnabledProfiles;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.util.license.LicenseManager;
import org.sourceid.websso.Protocol;

public abstract class AbstractSaasPluginBase
extends BaseSaasPlugin
implements ConnectionTemplate {
    private static final long serialVersionUID = 1L;
    private static Logger log = LogManager.getLogger(AbstractSaasPluginBase.class);
    private static org.apache.log4j.Logger userLogger = UserActivityLogger.getLogger();

    public abstract void initSaasConnection(List<Field> var1) throws SaasPluginException;

    public abstract void closeSaasConnection() throws SaasPluginException;

    public abstract void checkSaasConnection() throws SaasPluginException;

    public abstract String createUser(SaasUserData var1) throws SaasPluginException;

    public abstract SaasUserData getUser(String var1, String var2) throws SaasPluginException;

    public abstract String updateUser(SaasUserData var1, SaasUserData var2) throws SaasPluginException;

    public abstract List<SaasPluginFieldInfo> getFieldInfo() throws SaasPluginException;

    public abstract List<FieldDescriptor> getConnectionParameterDescriptors();

    public abstract String getSaasUserIdFieldName();

    public String deprovisionUser(SaasUserData existingSaasUserData, SaasUserData updatedSaasUserData) throws SaasPluginException {
        return this.updateUser(existingSaasUserData, updatedSaasUserData);
    }

    public void startSession() throws SaasException {
        this.initSaasConnection(this._parameters.getFields());
        super.startSession();
    }

    public void stopSession() throws SaasException {
        this.closeSaasConnection();
        super.stopSession();
    }

    public void checkSession() throws SaasException {
        this.checkSaasConnection();
    }

    protected void doCreateUser(SaasIdentity saasIdentity, UserUpdater userUpdater) throws SaasException {
        try {
            String userId = saasIdentity.getName();
            String saasGuid = this.createUser(AbstractSaasPluginBase.convertAndFilter(saasIdentity, this.getSaasUserIdFieldName(), true));
            if (saasGuid == null) {
                saasGuid = userId;
            }
            userUpdater.setSaasGuid(saasGuid);
            userUpdater.clearDirtyFlag();
            if (userLogger.isInfoEnabled()) {
                if (saasIdentity.isNameMasked() && saasGuid.equals(userId)) {
                    userLogger.info((Object)"Created user");
                } else {
                    userLogger.info((Object)("Created: " + saasGuid));
                }
            }
        }
        catch (Exception ex) {
            log.error("Exception in doCreateUser(). " + ex.getMessage());
            if (ex instanceof SaasException) {
                throw ex;
            }
            throw new SaasException((Throwable)ex);
        }
    }

    protected SaasIdentity doGetUser(SaasIdentity saasIdentity) throws SaasException {
        SaasIdentity requestedSaasIdentity = null;
        SaasUserData userData = this.getUser(saasIdentity.getGuid(), saasIdentity.getName());
        if (userData != null) {
            requestedSaasIdentity = this.convert(userData);
            requestedSaasIdentity.setSaasGuid(userData.getSaasUserGuid());
        }
        return requestedSaasIdentity;
    }

    private String getUserId(SaasIdentity saasIdentity) {
        return saasIdentity.getGuid() != null ? saasIdentity.getGuid() : saasIdentity.getName();
    }

    protected void doUpdateUser(SaasIdentity updatedSaasIdentity, SaasIdentity existingSaasIdentity, UserUpdater userUpdater) throws SaasException {
        this.modifyUser(updatedSaasIdentity, existingSaasIdentity, userUpdater, false);
    }

    protected void doDeprovisionUser(SaasIdentity updatedSaasIdentity, SaasIdentity existingSaasIdentity, UserUpdater userUpdater) throws SaasException {
        this.modifyUser(updatedSaasIdentity, existingSaasIdentity, userUpdater, true);
    }

    private void modifyUser(SaasIdentity updatedSaasIdentity, SaasIdentity existingSaasIdentity, UserUpdater userUpdater, boolean deprovision) throws SaasException {
        try {
            String existingUserId = this.getUserId(existingSaasIdentity);
            SaasUserData existingUserData = AbstractSaasPluginBase.convertAndFilter(existingSaasIdentity, this.getSaasUserIdFieldName(), false);
            SaasUserData updatedUserData = AbstractSaasPluginBase.convertAndFilter(updatedSaasIdentity, this.getSaasUserIdFieldName(), false);
            String newSaasGuid = deprovision ? this.deprovisionUser(existingUserData, updatedUserData) : this.updateUser(existingUserData, updatedUserData);
            if (newSaasGuid != null) {
                userUpdater.setSaasGuid(newSaasGuid);
            }
            userUpdater.clearDirtyFlag();
            if (userLogger.isInfoEnabled()) {
                if (existingSaasIdentity.isNameMasked() && existingUserId.equals(existingSaasIdentity.getName())) {
                    userLogger.info((Object)"Updated user");
                } else {
                    userLogger.info((Object)("Updated: " + existingUserId));
                }
            }
        }
        catch (Exception ex) {
            log.error("Exception in doUpdateUser(). " + ex.getMessage());
            throw new SaasException((Throwable)ex);
        }
    }

    protected void doLoadFieldsInfo() throws SaasException {
        ArrayList<SaasPluginFieldInfo> fldInfoList = new ArrayList<SaasPluginFieldInfo>();
        List<SaasPluginFieldInfo> tmpList = this.getFieldInfo();
        HashSet<String> persistMembershipFields = new HashSet<String>();
        if (tmpList != null && !tmpList.isEmpty()) {
            for (SaasPluginFieldInfo info : tmpList) {
                fldInfoList.add(info);
                if (!info.isPersistForMembership()) continue;
                persistMembershipFields.add(info.getCode());
            }
        }
        this.setFieldInfos(fldInfoList);
        this.setPersistForMembershipFields(persistMembershipFields);
    }

    protected Properties loadDefaultMappings() throws IOException {
        return new Properties();
    }

    public int getDefaultMaxThreads() {
        return 1;
    }

    public List<FieldDescriptor> getParameterDescriptors() {
        return this.getConnectionParameterDescriptors();
    }

    public String getSaasUsernameFieldCode() {
        return this.getSaasUserIdFieldName();
    }

    protected static SaasUserData convertAndFilter(SaasIdentity saasIdentity, String userIdFieldName, boolean isCreate) {
        SaasUserData userData = null;
        if (saasIdentity != null) {
            userData = new SaasUserData(saasIdentity.getGuid());
            userData.setAccountEnabled(saasIdentity.isActive());
            userData.setInternalGuid(saasIdentity.getInternalGuid());
            Set attributeNames = saasIdentity.getNames();
            String userId = saasIdentity.getName();
            userData.addAttribute(userIdFieldName, userId);
            if (attributeNames != null && !attributeNames.isEmpty()) {
                for (String name : attributeNames) {
                    if (saasIdentity.isMapValue(name)) {
                        userData.getMapAttributesMap().put(name, saasIdentity.getMap(name));
                        continue;
                    }
                    if (!isCreate && saasIdentity.isFieldCreateOnly(name)) continue;
                    userData.addAttribute(name, saasIdentity.getValues(name));
                }
            }
            userData.setMaskedFields(saasIdentity.getMaskedFields());
        }
        return userData;
    }

    private SaasIdentity convert(SaasUserData userData) {
        SaasIdentity saasIdentity = null;
        if (userData != null) {
            saasIdentity = new SaasIdentity(this.getSaasUserIdFieldName());
            saasIdentity.setAccountEnabled(userData.isAccountEnabled());
            saasIdentity.setInProvisioningGroup(userData.isAccountEnabled());
            Set<String> attributeNames = userData.getAttributeMap().keySet();
            if (attributeNames != null && !attributeNames.isEmpty()) {
                for (String name : attributeNames) {
                    saasIdentity.putValues(name, userData.getAttributeValues(name));
                }
            }
        }
        return saasIdentity;
    }

    public List<String> checkPrerequisites() {
        return null;
    }

    public ConnectionBase getConnection(SimpleFieldList fieldList) {
        SpConnection spConnection = new SpConnection();
        String entityId = this.getSaasProviderEntityId();
        spConnection.setEntityId(entityId);
        spConnection.setProtocol(Protocol.SAML20);
        spConnection.setOrganization(null);
        EnabledProfiles enabledProfiles = new EnabledProfiles();
        enabledProfiles.setIdpInitiatedSLOEnabled(false);
        enabledProfiles.setIdpInitiatedSSOEnabled(true);
        enabledProfiles.setSpInitiatedSLOEnabled(false);
        enabledProfiles.setSpInitiatedSSOEnabled(false);
        spConnection.setEnabledProfiles(enabledProfiles);
        spConnection.getIncomingBindings().setArtifactBinding(true);
        spConnection.getIncomingBindings().setPostBinding(true);
        spConnection.getIncomingBindings().setRedirectBinding(true);
        spConnection.getIncomingBindings().setSoapBinding(true);
        if (LicenseManager.isFeatureEnabled((String)"SaasProvisioning") && ProvisionerManager.getProvisionerGlobalSettings().isEnabledInGui()) {
            ProvisionerConfig provisionerConfig = new ProvisionerConfig(spConnection.getEntityId());
            spConnection.addConnectionModuleConfiguration((ConnectionModuleConfiguration)provisionerConfig);
        }
        return spConnection;
    }

    public List<FieldDescriptor> getFieldDescriptors() {
        return null;
    }

    public String getNote() {
        return null;
    }

    protected String getSaasProviderEntityId() {
        return "";
    }
}

