/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.channel;

import com.pingidentity.common.util.TinyHashSet;
import com.pingidentity.provisioner.channel.SecondPhaseDirectoryGroupWorker;
import com.pingidentity.provisioner.cluster.ClusteringException;
import com.pingidentity.provisioner.directory.DirectoryDriver;
import com.pingidentity.provisioner.directory.DirectoryException;
import com.pingidentity.provisioner.directory.DirectoryResourceCallback;
import com.pingidentity.provisioner.identity.DirectoryGroup;
import com.pingidentity.provisioner.mapping.AttributesMapper;
import com.pingidentity.provisioner.resources.DirectoryResource;
import java.util.List;
import java.util.Set;

public class AddSubGroupMembershipCallback
implements DirectoryResourceCallback {
    private final TinyHashSet<String> guidsWorkedOn;
    private final DirectoryDriver directoryDriver;
    private final SecondPhaseDirectoryGroupWorker secondGroupWorker;

    public AddSubGroupMembershipCallback(TinyHashSet<String> guidsWorkedOn, DirectoryDriver directoryDriver, SecondPhaseDirectoryGroupWorker secondGroupWorker) {
        this.guidsWorkedOn = guidsWorkedOn;
        this.directoryDriver = directoryDriver;
        this.secondGroupWorker = secondGroupWorker;
    }

    @Override
    public Set<String> getAttributeNames() {
        return this.secondGroupWorker.getAttributeNames();
    }

    @Override
    public void process(String dn, DirectoryResource resource) throws DirectoryException, ClusteringException {
        DirectoryGroup dirGroup = (DirectoryGroup)resource;
        String guid = dirGroup.getGuid();
        if (this.guidsWorkedOn.contains((Object)guid)) {
            this.secondGroupWorker.work(dn, dirGroup);
        }
    }

    @Override
    public List<DirectoryResourceCallback.DirectoryCallbackProcessException> getNonFatalExceptions() {
        return this.secondGroupWorker.getNonFatalExceptions();
    }

    @Override
    public AttributesMapper getAttributeMapper() {
        return this.directoryDriver.getDirectoryGroupAttributesMapper();
    }

    public boolean hasGuidsToWorkOn() {
        return this.guidsWorkedOn != null && !this.guidsWorkedOn.isEmpty();
    }
}

