/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.channel;

import com.pingidentity.common.util.TinyHashSet;
import com.pingidentity.provisioner.channel.AddRemoveGroupsCallback;
import com.pingidentity.provisioner.channel.AddSubGroupMembershipCallback;
import com.pingidentity.provisioner.channel.AttributeSyncCallback;
import com.pingidentity.provisioner.channel.BaseProvisioningChannel;
import com.pingidentity.provisioner.channel.DirectoryGroupWorker;
import com.pingidentity.provisioner.channel.GroupSyncCallback;
import com.pingidentity.provisioner.channel.PassiveProvisioningCallback;
import com.pingidentity.provisioner.channel.SecondPhaseDirectoryGroupWorker;
import com.pingidentity.provisioner.channel.asynchronous.AsynchronousSaasCallback;
import com.pingidentity.provisioner.channel.synchronous.SynchronousSaasCallback;
import com.pingidentity.provisioner.cluster.ClusteringException;
import com.pingidentity.provisioner.cluster.NoopProvisionerClusterManager;
import com.pingidentity.provisioner.cluster.ProvisionerClusterManager;
import com.pingidentity.provisioner.cluster.RuntimeClusteringException;
import com.pingidentity.provisioner.cluster.StopProvisionerException;
import com.pingidentity.provisioner.directory.DirectoryDriver;
import com.pingidentity.provisioner.directory.DirectoryException;
import com.pingidentity.provisioner.directory.DirectoryResourceCallback;
import com.pingidentity.provisioner.directory.ResourceCallbackCriteria;
import com.pingidentity.provisioner.directory.spring.RuntimeDirectoryException;
import com.pingidentity.provisioner.identity.DirectoryIdentity;
import com.pingidentity.provisioner.identity.SaasGroup;
import com.pingidentity.provisioner.identity.SaasIdentity;
import com.pingidentity.provisioner.mapping.IdentityMapper;
import com.pingidentity.provisioner.mapping.MappingException;
import com.pingidentity.provisioner.monitor.ProvisioningEventTimer;
import com.pingidentity.provisioner.saas.SaasException;
import com.pingidentity.provisioner.saas.SaasProvisionerPlugin;
import com.pingidentity.provisioner.saas.SaasProvisionerPluginGroupsWithMembersExt;
import com.pingidentity.provisioner.store.DelayedVariableUpdater;
import com.pingidentity.provisioner.store.DuplicateKeyException;
import com.pingidentity.provisioner.store.ProvisionableResourceMeta;
import com.pingidentity.provisioner.store.SaasProvisionableResourceCallback;
import com.pingidentity.provisioner.store.UserStore;
import com.pingidentity.provisioner.store.VariableStore;
import com.pingidentity.provisioner.store.VariableStoreVariable;
import com.pingidentity.provisioner.store.groups.GroupMembershipStore;
import com.pingidentity.provisioner.store.groups.GroupStore;
import com.pingidentity.provisioner.store.groups.GroupStoreException;
import com.unboundid.ldap.sdk.Filter;
import com.unboundid.ldap.sdk.LDAPException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.transaction.support.TransactionTemplate;

public class GenericUserProvisioningChannel
extends BaseProvisioningChannel {
    public static final String VAR_PASSIVE_PROV_LAST_TIMESTAMP = "passive_last_timestamp";
    public static final String VAR_ATTRIB_SYNC_LAST_TIMESTAMP = "attrib_last_timestamp";
    private static final String VAR_USERS_GROUP_AND_FILTER = "users_group_and_filter";
    private static final String VAR_USERS_GROUP_NESTED_SEARCH = "users_group_nested_search";
    private static final String VAR_GROUPS_GROUP_AND_FILTER = "groups_group_and_filter";
    private static final String VAR_IDENTITY_MAPPING_HASH = "identity_mapping_hash";
    private static Logger _logger = LogManager.getLogger(GenericUserProvisioningChannel.class);
    private UserStore _userStore;
    private GroupStore _groupStore;
    private GroupMembershipStore _groupMembershipStore;
    private VariableStore _variableStore;
    private IdentityMapper _identityMapper;
    private boolean _enableAttributeSync = true;
    private String _passiveProvisioningGroupDnForUsers = "";
    private Filter _passiveProvisioningFilterForUsers = null;
    private SaasProvisionerPlugin _saasDriver;
    private boolean _deleteDeprovisionedUsers = true;
    private boolean _deleteDeprovisionedGroups = true;
    private int _maxSaasThreads = 1;
    private int _timeout;
    private ProvisionerClusterManager _clusterManager = new NoopProvisionerClusterManager();
    private String _passiveProvisioningGroupDnForGroups = "";
    private Filter _passiveProvisioningGroupFilterForGroups = null;
    private boolean _userNestedSearch;
    private boolean _groupNestedSearch;
    private boolean _hasSubGroupColumn = true;
    private String _identityMappingHash;
    private TransactionTemplate _transactionTemplate;

    private boolean isGroupProvisioningEnabled() {
        boolean pluginConfiguredForGroups = true;
        if (this._saasDriver instanceof SaasProvisionerPluginGroupsWithMembersExt) {
            pluginConfiguredForGroups = ((SaasProvisionerPluginGroupsWithMembersExt)((Object)this._saasDriver)).isConfiguredForGroups();
        }
        return pluginConfiguredForGroups && (StringUtils.isNotEmpty((String)this._passiveProvisioningGroupDnForGroups) || this._passiveProvisioningGroupFilterForGroups != null);
    }

    public void setTransactionTemplate(TransactionTemplate transactionTemplate) {
        this._transactionTemplate = transactionTemplate;
    }

    public void setUserStore(UserStore userStore) {
        this._userStore = userStore;
    }

    public void setGroupStore(GroupStore groupStore) {
        this._groupStore = groupStore;
    }

    public void setVariableStore(VariableStore variableStore) {
        this._variableStore = variableStore;
    }

    public void setIdentityMapper(IdentityMapper identityMapper) {
        this._identityMapper = identityMapper;
    }

    public void setEnableAttributeSync(boolean enableAttributeSync) {
        this._enableAttributeSync = enableAttributeSync;
    }

    public void setPassiveProvisioningGroupDnForUsers(String passiveProvisioningGroupDnForUsers) {
        if (passiveProvisioningGroupDnForUsers != null) {
            this._passiveProvisioningGroupDnForUsers = passiveProvisioningGroupDnForUsers.trim();
        }
    }

    public void setPassiveProvisioningFilterForUsers(String passiveProvisioningFilterForUsers) throws LDAPException {
        String trimmedFilter = StringUtils.strip((String)passiveProvisioningFilterForUsers);
        this._passiveProvisioningFilterForUsers = StringUtils.isEmpty((String)trimmedFilter) ? null : Filter.create((String)trimmedFilter);
    }

    public void setPassiveProvisioningGroupDnForGroups(String passiveProvisioningGroupDnForGroups) {
        this._passiveProvisioningGroupDnForGroups = passiveProvisioningGroupDnForGroups;
    }

    public void setPassiveProvisioningGroupFilterForGroups(String passiveProvisioningGroupFilterForGroups) throws LDAPException {
        String trimmedFilter = StringUtils.strip((String)passiveProvisioningGroupFilterForGroups);
        this._passiveProvisioningGroupFilterForGroups = StringUtils.isEmpty((String)trimmedFilter) ? null : Filter.create((String)trimmedFilter);
    }

    @Override
    public void setDirectoryDriver(DirectoryDriver directoryDriver) {
        this._directoryDriver = directoryDriver;
    }

    @Override
    public void setSaasDriver(SaasProvisionerPlugin saasDriver) {
        this._saasDriver = saasDriver;
    }

    public void setDeleteDeprovisionedUsers(boolean deleteDeprovisionedUsers) {
        this._deleteDeprovisionedUsers = deleteDeprovisionedUsers;
    }

    public void setDeleteDeprovisionedGroups(boolean _deleteDeprovisionedGroups) {
        this._deleteDeprovisionedGroups = _deleteDeprovisionedGroups;
    }

    public void setMaxSaasThreads(int maxSaasThreads) {
        this._maxSaasThreads = maxSaasThreads;
    }

    public void setTimeout(int timeout) {
        this._timeout = timeout;
    }

    @Override
    public void start() throws SaasException {
        this._saasDriver.startSession();
    }

    @Override
    public void stop() throws SaasException {
        this._saasDriver.stopSession();
        this._clusterManager.stopNode();
    }

    public ProvisionerClusterManager getClusterManager() {
        return this._clusterManager;
    }

    public void setClusterManager(ProvisionerClusterManager clusterManager) {
        this._clusterManager = clusterManager;
    }

    @Override
    public Set<String> run(Set<String> usersToIgnore, Map<String, Integer> unManagedUsers) {
        _logger.info("Starting provisioning cycle for channel: " + this.getChannelName() + " (" + this.getChannelId() + ") [" + this.getChannelCode() + "] in connection " + this.getConnectionId());
        Set<String> managedUserGuids = Collections.emptySet();
        try {
            this._clusterManager.sendHeartBeat();
            boolean groupProvisioningEnabledToDisabled = this.isGroupProvisioningEnabledToDisabled();
            boolean passiveProvForGroupAssignmentNeeded = !unManagedUsers.isEmpty();
            unManagedUsers.entrySet().removeIf(u -> ((Integer)u.getValue()).intValue() == this.getChannelId());
            Set<String>[] removedGuids = this.collectUpdates(groupProvisioningEnabledToDisabled, usersToIgnore, unManagedUsers, passiveProvForGroupAssignmentNeeded);
            Set<String> removedUserGuids = removedGuids[0];
            Set<String> removedGroupGuids = removedGuids[1];
            Set<String> skipUpdateUsers = unManagedUsers.entrySet().stream().filter(entry -> ((Integer)entry.getValue()).intValue() == this.getChannelId()).map(entry -> (String)entry.getKey()).collect(Collectors.toSet());
            this.pushUpdates(removedUserGuids, removedGroupGuids, groupProvisioningEnabledToDisabled, skipUpdateUsers);
            try (ProvisioningEventTimer ignored = ProvisioningEventTimer.getInternalUserStoreEventTimer("Retrieving all user guids from the internal database");){
                managedUserGuids = this._userStore.getAllUserGuids();
            }
            managedUserGuids.removeAll(skipUpdateUsers);
        }
        catch (DirectoryException e) {
            _logger.error("Channel run error!", (Throwable)e);
        }
        catch (StopProvisionerException e) {
            _logger.info("Provisioner forced down!");
            _logger.debug("Provisioner forced down!", (Throwable)e);
        }
        catch (ClusteringException e) {
            _logger.error("Channel clustering error!", (Throwable)e);
        }
        catch (RuntimeDirectoryException e) {
            _logger.error("Channel run error!", (Throwable)e);
        }
        catch (RuntimeClusteringException e) {
            Throwable cause = e.getCause();
            if (cause instanceof StopProvisionerException) {
                _logger.info("Provisioner forced down");
                _logger.debug("Provisioner forced down", (Throwable)e);
            }
            _logger.error("Channel clustering error!", (Throwable)e);
        }
        return managedUserGuids;
    }

    private boolean isGroupProvisioningEnabledToDisabled() {
        String oldGroupsGroupAndFilter = this._variableStore.getStringVariable(VAR_GROUPS_GROUP_AND_FILTER);
        String newGroupsGroupAndFilter = this.createGroupsGroupAndFilterVariable();
        if (oldGroupsGroupAndFilter != null && !oldGroupsGroupAndFilter.equalsIgnoreCase(newGroupsGroupAndFilter) && this._passiveProvisioningGroupDnForGroups == null && this._passiveProvisioningGroupFilterForGroups == null) {
            _logger.info("Group provisioning is disabled... clearing all groups.");
            return true;
        }
        return false;
    }

    private void pushUpdates(Set<String> removedUserGuids, Set<String> removedGroupGuids, boolean groupProvisioningEnabledToDisabled, Set<String> usersToSkip) throws ClusteringException {
        this.getProvisioningEventLogger().startTargetProvisioning();
        _logger.info("Pushing user/group updates to the target. Using " + this._maxSaasThreads + " threads and a timeout of " + this._timeout + " seconds.");
        if ((this.isGroupProvisioningEnabled() || groupProvisioningEnabledToDisabled) && this._groupStore.getDirtyGroupCount() > 0) {
            if (this._saasDriver instanceof SaasProvisionerPluginGroupsWithMembersExt) {
                boolean userUpdateSuccessful = this.pushDirtyUsers(usersToSkip);
                if (userUpdateSuccessful) {
                    this.clearDirtyGroups();
                } else {
                    _logger.error("Error pushing dirty users, skipping group provisioning");
                }
            } else {
                this.clearDirtyGroups();
                this.pushDirtyUsers(usersToSkip);
            }
        } else {
            this.pushDirtyUsers(usersToSkip);
        }
        if (this._deleteDeprovisionedUsers && removedUserGuids.size() > 0) {
            _logger.debug("\tDeleting deprovisioned user records...");
            this.deleteUserGuids(removedUserGuids, true);
        }
        if (this._deleteDeprovisionedGroups && removedGroupGuids.size() > 0) {
            _logger.debug("\tDeleting deprovisioned group records...");
            this.deleteGroupGuids(removedGroupGuids);
        }
        this.getProvisioningEventLogger().logTargetProvSummary();
    }

    private boolean pushDirtyUsers(Set<String> usersToSkip) {
        if (this._userStore.getDirtyUserCount() > 0) {
            _logger.debug("\tClearing dirty user records...");
            try {
                this.clearDirtyUsers(usersToSkip);
            }
            catch (SaasException e) {
                return false;
            }
        }
        return true;
    }

    private Set<String>[] collectUpdates(boolean groupProvisioningEnabledToDisabled, Set<String> usersToIgnore, Map<String, Integer> unManagedUsers, boolean passiveProvForGroupAssignmentNeeded) throws DirectoryException, ClusteringException {
        String newGroupsGroupAndFilter;
        String newUsersGroupAndFilter;
        HashSet removedUserGuids = new HashSet();
        Set<Object> removedGroupGuids = new HashSet();
        DelayedVariableUpdater variableUpdater = new DelayedVariableUpdater(this._variableStore, VAR_PASSIVE_PROV_LAST_TIMESTAMP);
        boolean usersNeedReprovisioningToUpdateGroupMembership = false;
        boolean pluginSupportsLdapGroupMemberships = this._saasDriver instanceof SaasProvisionerPluginGroupsWithMembersExt;
        boolean hasUsersBeenAddedRemoved = false;
        String oldUsersGroupAndFilter = this._variableStore.getStringVariable(VAR_USERS_GROUP_AND_FILTER);
        String oldUsersGroupNestedSearch = this._variableStore.getStringVariable(VAR_USERS_GROUP_NESTED_SEARCH);
        String oldGroupsGroupAndFilter = this._variableStore.getStringVariable(VAR_GROUPS_GROUP_AND_FILTER);
        if (oldUsersGroupAndFilter != null && oldGroupsGroupAndFilter != null && oldUsersGroupNestedSearch != null) {
            newUsersGroupAndFilter = this.createUsersGroupAndFilterVariable();
            newGroupsGroupAndFilter = this.createGroupsGroupAndFilterVariable();
            if (!(oldUsersGroupAndFilter.equalsIgnoreCase(newUsersGroupAndFilter) && oldGroupsGroupAndFilter.equalsIgnoreCase(newGroupsGroupAndFilter) && oldUsersGroupNestedSearch.equals(String.valueOf(this._userNestedSearch)))) {
                _logger.debug("Source settings have changed... clearing provisioner timestamps");
                this._variableStore.deleteVariable(VAR_PASSIVE_PROV_LAST_TIMESTAMP);
                this._variableStore.deleteVariable(VAR_ATTRIB_SYNC_LAST_TIMESTAMP);
                this.saveVariableStore(newUsersGroupAndFilter, newGroupsGroupAndFilter);
            }
        } else {
            newUsersGroupAndFilter = this.createUsersGroupAndFilterVariable();
            newGroupsGroupAndFilter = this.createGroupsGroupAndFilterVariable();
            this.saveVariableStore(newUsersGroupAndFilter, newGroupsGroupAndFilter);
        }
        String oldIdentityMappingHash = this._variableStore.getStringVariable(VAR_IDENTITY_MAPPING_HASH);
        if (oldIdentityMappingHash == null) {
            _logger.debug("Creating identity mapping hash variable (" + this._identityMappingHash + ")");
            this._variableStore.setStringVariable(VAR_IDENTITY_MAPPING_HASH, this._identityMappingHash);
        } else if (!oldIdentityMappingHash.equals(this._identityMappingHash)) {
            _logger.debug("Identity mapping hash has changed (" + this._identityMappingHash + "), clearing attribute sync timestamp");
            this._variableStore.deleteVariable(VAR_ATTRIB_SYNC_LAST_TIMESTAMP);
            this._variableStore.setStringVariable(VAR_IDENTITY_MAPPING_HASH, this._identityMappingHash);
        }
        if (this.passiveProvisioningNeeded(variableUpdater) || passiveProvForGroupAssignmentNeeded) {
            Object[] rVals = this.collectPassiveProvisioningEvents(usersToIgnore, unManagedUsers);
            removedUserGuids = (HashSet)rVals[0];
            boolean selfDeconflictionFound = (Boolean)rVals[1];
            boolean hasNonFatalErrors = (Boolean)rVals[2];
            hasUsersBeenAddedRemoved = (Boolean)rVals[3];
            if (!selfDeconflictionFound && !hasNonFatalErrors) {
                variableUpdater.update();
            }
        } else {
            _logger.info("Passive provisioning not needed.");
        }
        if (this.isGroupProvisioningEnabled()) {
            _logger.info("Collecting added/removed groups...");
            removedGroupGuids = this.collectAddRemoveGroupsEvents(pluginSupportsLdapGroupMemberships);
        } else if (groupProvisioningEnabledToDisabled) {
            _logger.info("Group provisioning is disabled - collecting removed groups...");
            removedGroupGuids = this.markAllGroupsAsDirty();
        }
        this.getProvisioningEventLogger().logPassiveProvSummary();
        if (this._groupStore.getDirtyGroupCount() > 0 && !pluginSupportsLdapGroupMemberships) {
            usersNeedReprovisioningToUpdateGroupMembership = true;
        }
        if (this.attributeSyncNeeded() || usersNeedReprovisioningToUpdateGroupMembership) {
            boolean groupsNeedReprovisioning = hasUsersBeenAddedRemoved && (this._passiveProvisioningFilterForUsers != null || !this.createUsersGroupAndFilterVariable().equalsIgnoreCase(oldUsersGroupAndFilter));
            this.collectAttributeSyncEvents(!pluginSupportsLdapGroupMemberships, usersNeedReprovisioningToUpdateGroupMembership, groupsNeedReprovisioning, usersToIgnore);
        } else {
            _logger.info("No attribute sync needed.");
        }
        return new Set[]{removedUserGuids, removedGroupGuids};
    }

    private Set<String> markAllGroupsAsDirty() throws ClusteringException {
        HashMap<String, SaasGroup> insideGroups = new HashMap<String, SaasGroup>();
        HashSet<String> groupsToRemove = new HashSet<String>();
        this._groupStore.loadDirectoryServerGuids(insideGroups, new HashMap<String, SaasGroup>());
        this.removeGroupsFromProvisioningGroup(insideGroups, groupsToRemove);
        return groupsToRemove;
    }

    private void saveVariableStore(String newUsersGroupAndFilter, String newGroupsGroupAndFilter) {
        this._variableStore.setStringVariable(VAR_USERS_GROUP_AND_FILTER, newUsersGroupAndFilter);
        this._variableStore.setStringVariable(VAR_USERS_GROUP_NESTED_SEARCH, String.valueOf(this._userNestedSearch));
        this._variableStore.setStringVariable(VAR_GROUPS_GROUP_AND_FILTER, newGroupsGroupAndFilter);
    }

    private String createUsersGroupAndFilterVariable() {
        StringBuilder builder = new StringBuilder();
        builder.append(this._passiveProvisioningGroupDnForUsers);
        builder.append('&');
        if (this._passiveProvisioningFilterForUsers != null) {
            builder.append(this._passiveProvisioningFilterForUsers.encode());
        }
        return builder.toString();
    }

    private String createGroupsGroupAndFilterVariable() {
        StringBuilder builder = new StringBuilder();
        builder.append(this._passiveProvisioningGroupDnForGroups);
        builder.append('&');
        if (this._passiveProvisioningGroupFilterForGroups != null) {
            builder.append(this._passiveProvisioningGroupFilterForGroups.encode());
        }
        return builder.toString();
    }

    private void deleteUserGuids(Set<String> guids, boolean cleanUsersOnly) throws ClusteringException {
        for (String guid : guids) {
            this._clusterManager.sendHeartBeat();
            _logger.info("Removing user from store: " + guid);
            if (cleanUsersOnly) {
                this._userStore.removeIfNotDirty(guid);
                continue;
            }
            this._userStore.remove(guid);
        }
    }

    private void deleteGroupGuids(Set<String> guids) throws ClusteringException {
        for (String guid : guids) {
            this._clusterManager.sendHeartBeat();
            _logger.info("Removing deprovisioned clean group from store: " + guid);
            this._groupStore.removeIfNotDirty(guid);
        }
    }

    private Set<String> collectAddRemoveGroupsEvents(boolean isGroupMembershipSupported) throws DirectoryException, ClusteringException {
        HashMap<String, SaasGroup> insideGroups = new HashMap<String, SaasGroup>();
        HashMap<String, SaasGroup> outsideGroups = new HashMap<String, SaasGroup>();
        HashSet<String> groupsToRemove = new HashSet<String>();
        this._groupStore.loadDirectoryServerGuids(insideGroups, outsideGroups);
        boolean usingDnAsGroupName = this.isUsingDnAsGroupName();
        Filter filterForUsers = null;
        String groupDnForUsers = null;
        if (this.isUsingGroupDnForUsers()) {
            if (this._userNestedSearch) {
                filterForUsers = Filter.createEqualityFilter((String)this._directoryDriver.getNestedMemberOfGroupAttributeName(), (String)this._passiveProvisioningGroupDnForUsers);
            } else {
                groupDnForUsers = this._passiveProvisioningGroupDnForUsers;
            }
        } else {
            filterForUsers = this._passiveProvisioningFilterForUsers;
        }
        DirectoryGroupWorker groupWorker = new DirectoryGroupWorker(this._groupStore, this._groupMembershipStore, this._clusterManager, usingDnAsGroupName, isGroupMembershipSupported, this._directoryDriver, filterForUsers, groupDnForUsers, null, this._hasSubGroupColumn, this._transactionTemplate, this.getProvisioningEventLogger());
        TinyHashSet guidsWorkedOn = new TinyHashSet();
        AddRemoveGroupsCallback callback = new AddRemoveGroupsCallback(insideGroups, outsideGroups, this._directoryDriver, groupWorker, (TinyHashSet<String>)guidsWorkedOn);
        AddSubGroupMembershipCallback subGroupMembershipCallback = null;
        if (isGroupMembershipSupported && this._hasSubGroupColumn) {
            Filter groupFilterForGroups = null;
            String groupDnForGroups = null;
            if (this.isUsingGroupDnForGroups()) {
                if (this._groupNestedSearch) {
                    groupFilterForGroups = Filter.createEqualityFilter((String)this._directoryDriver.getNestedMemberOfGroupAttributeName(), (String)this._passiveProvisioningGroupDnForGroups);
                } else {
                    groupDnForGroups = this._passiveProvisioningGroupDnForGroups;
                }
            } else {
                groupFilterForGroups = this._passiveProvisioningGroupFilterForGroups;
            }
            SecondPhaseDirectoryGroupWorker secondGroupWorker = new SecondPhaseDirectoryGroupWorker(this._groupStore, this._groupMembershipStore, this._clusterManager, usingDnAsGroupName, this._directoryDriver, groupFilterForGroups, groupDnForGroups);
            subGroupMembershipCallback = new AddSubGroupMembershipCallback((TinyHashSet<String>)guidsWorkedOn, this._directoryDriver, secondGroupWorker);
        }
        this.processGroups(callback, subGroupMembershipCallback);
        this.handleDirectoryCallbackErrors(callback);
        if (subGroupMembershipCallback != null) {
            this.handleDirectoryCallbackErrors(subGroupMembershipCallback);
        }
        this.removeGroupsFromProvisioningGroup(insideGroups, groupsToRemove);
        groupsToRemove.addAll(outsideGroups.keySet());
        return groupsToRemove;
    }

    private void removeGroupsFromProvisioningGroup(Map<String, SaasGroup> insideGroups, Set<String> groupsToRemove) throws ClusteringException {
        for (Map.Entry<String, SaasGroup> insideSaasGroupEntry : insideGroups.entrySet()) {
            this._clusterManager.sendHeartBeat();
            String guid = insideSaasGroupEntry.getKey();
            SaasGroup saasGroup = insideSaasGroupEntry.getValue();
            this._groupStore.update(guid, saasGroup, false);
            groupsToRemove.add(guid);
            _logger.debug("Group removed from provisioning group, marked as inactive: " + guid);
        }
    }

    private void processGroupsInOneStep(DirectoryResourceCallback callback, boolean isGroupMembershipSupported) throws DirectoryException {
        this.processGroupsInOneStep(callback, isGroupMembershipSupported, null);
    }

    private void processGroupsInOneStep(DirectoryResourceCallback callback, boolean isGroupMembershipSupported, ResourceCallbackCriteria criteria) throws DirectoryException {
        this.processGroupsHelper(callback, isGroupMembershipSupported, null, criteria);
    }

    private void processGroups(DirectoryResourceCallback callback, AddSubGroupMembershipCallback subGroupMembeshipCallback) throws DirectoryException {
        this.processGroupsHelper(callback, subGroupMembeshipCallback != null, subGroupMembeshipCallback, null);
    }

    private void processGroupsHelper(DirectoryResourceCallback callback, boolean isGroupMembershipSupported, AddSubGroupMembershipCallback subGroupMembeshipCallback, ResourceCallbackCriteria criteria) throws DirectoryException {
        if (criteria == null) {
            criteria = new ResourceCallbackCriteria();
        }
        criteria.setObjectClassCriterion(this._directoryDriver.getGroupObjectClass());
        this.doProcessGroups(callback, criteria);
        if (subGroupMembeshipCallback != null && subGroupMembeshipCallback.hasGuidsToWorkOn()) {
            this.doProcessGroups(subGroupMembeshipCallback, criteria);
        }
        if (isGroupMembershipSupported) {
            try {
                this._groupMembershipStore.commit();
            }
            catch (GroupStoreException e) {
                throw new DirectoryException(e);
            }
        }
    }

    private void doProcessGroups(DirectoryResourceCallback callback, ResourceCallbackCriteria criteria) throws DirectoryException {
        if (this.isUsingGroupDnForGroups()) {
            if (this._groupNestedSearch) {
                Filter filter = Filter.createEqualityFilter((String)this._directoryDriver.getNestedMemberOfGroupAttributeName(), (String)this._passiveProvisioningGroupDnForGroups);
                this._directoryDriver.processResourcesByFilter(filter, criteria, callback);
            } else {
                this._directoryDriver.processResourcesInGroup(this._passiveProvisioningGroupDnForGroups, criteria, callback);
            }
        } else {
            this._directoryDriver.processResourcesByFilter(this._passiveProvisioningGroupFilterForGroups, criteria, callback);
        }
    }

    private Object[] collectPassiveProvisioningEvents(Set<String> usersToIgnore, Map<String, Integer> unManagedUsers) throws DirectoryException, ClusteringException {
        this.getProvisioningEventLogger().startPassiveProvisioning();
        _logger.info("User addition and group membership change detection stage started.");
        _logger.info("Collecting added/removed users...");
        HashSet<String> insideGuids = new HashSet<String>();
        HashSet<String> outsideGuids = new HashSet<String>();
        HashSet<String> conflictedSaasUsernames = new HashSet<String>();
        try (ProvisioningEventTimer ignored = ProvisioningEventTimer.getInternalUserStoreEventTimer("Retrieving all user guids from the internal database");){
            this._userStore.loadDirectoryServerGuids(insideGuids, outsideGuids);
        }
        PassiveProvisioningCallback callback = new PassiveProvisioningCallback(insideGuids, outsideGuids, conflictedSaasUsernames, this._userStore, this._directoryDriver, this._identityMapper, this._clusterManager, usersToIgnore, unManagedUsers, this.getProvisioningEventLogger());
        this.processUsers(callback);
        this.handleDirectoryCallbackErrors(callback);
        this.removeUsersToIgnore(usersToIgnore, insideGuids, outsideGuids);
        for (String guid : insideGuids) {
            this._clusterManager.sendHeartBeat();
            try {
                SaasIdentity saasIdentity;
                DirectoryIdentity directoryIdentity = this._directoryDriver.loadUserByGuid(this._identityMapper.getAttributeNames(), guid);
                if (directoryIdentity != null) {
                    saasIdentity = this._identityMapper.map(directoryIdentity);
                } else {
                    _logger.warn("User deleted from directory server: " + guid);
                    String saasUsernameFieldCode = this._saasDriver.getSaasUsernameFieldCode();
                    saasIdentity = new SaasIdentity(saasUsernameFieldCode);
                    saasIdentity.setInProvisioningGroup(false);
                    saasIdentity.setAccountEnabled(false);
                    String saasUsername = this._userStore.getSaasUsername(guid);
                    saasIdentity.putValues(saasUsernameFieldCode, saasUsername, new String[0]);
                }
                this._userStore.update(guid, saasIdentity, false);
                unManagedUsers.put(guid, this.getChannelId());
            }
            catch (MappingException e) {
                _logger.error("Directory server user with GUID: " + guid + " cannot be mapped!", (Throwable)e);
            }
            catch (DuplicateKeyException e) {
                _logger.error("User update skipped for GUID: " + guid + " collision with saasUsername: " + e.getConflictValue());
            }
            catch (SaasException e) {
                _logger.error("Cannot create SaaS identity for user: " + guid, (Throwable)e);
            }
        }
        boolean selfDeconfliction = this.checkForSelfDeconfliction(conflictedSaasUsernames, outsideGuids);
        Object[] returnValues = new Object[]{outsideGuids, selfDeconfliction, callback.getNonFatalExceptions().size() > 0, callback.hasUsersBeenAddedRemoved()};
        return returnValues;
    }

    private void removeUsersToIgnore(Set<String> usersToIgnore, Set<String> insideGuids, Set<String> outsideGuids) {
        if (usersToIgnore != null) {
            _logger.debug("Deleting users that are managed by other channels");
            for (Set dbGuids : Arrays.asList(insideGuids, outsideGuids)) {
                HashSet<String> guidsToRemove = new HashSet<String>();
                for (String dbGuid : dbGuids) {
                    if (!usersToIgnore.contains(dbGuid)) continue;
                    this._userStore.remove(dbGuid);
                    guidsToRemove.add(dbGuid);
                    this.getProvisioningEventLogger().passiveProvUserRemoved();
                }
                dbGuids.removeAll(guidsToRemove);
            }
        }
    }

    private void processUsers(DirectoryResourceCallback callback) throws DirectoryException {
        this.processUsers(callback, null);
    }

    private void processUsers(DirectoryResourceCallback callback, ResourceCallbackCriteria criteria) throws DirectoryException {
        if (criteria == null) {
            criteria = new ResourceCallbackCriteria();
        }
        criteria.setObjectClassCriterion(this._directoryDriver.getUserObjectClass());
        if (this.isUsingGroupDnForUsers()) {
            if (this._userNestedSearch) {
                Filter filter = Filter.createEqualityFilter((String)this._directoryDriver.getNestedMemberOfGroupAttributeName(), (String)this._passiveProvisioningGroupDnForUsers);
                this._directoryDriver.processResourcesByFilter(filter, criteria, callback);
            } else {
                this._directoryDriver.processResourcesInGroup(this._passiveProvisioningGroupDnForUsers, criteria, callback);
            }
        } else {
            this._directoryDriver.processResourcesByFilter(this._passiveProvisioningFilterForUsers, criteria, callback);
        }
    }

    private void handleDirectoryCallbackErrors(DirectoryResourceCallback callback) {
        for (DirectoryResourceCallback.DirectoryCallbackProcessException processException : callback.getNonFatalExceptions()) {
            _logger.error(processException.getMessage(), processException.getCause());
        }
    }

    private boolean checkForSelfDeconfliction(Set<String> conflictedSaasUsernames, Set<String> removedUserGuids) {
        for (String saasUsername : conflictedSaasUsernames) {
            String conflictedGuid;
            ProvisionableResourceMeta userStoreIdentity = this._userStore.getUserMetaBySaasUsername(saasUsername);
            if (userStoreIdentity == null || !removedUserGuids.contains(conflictedGuid = userStoreIdentity.getDirectoryServerGuid())) continue;
            _logger.debug("self correcting conflict identified for to be removed GUID " + conflictedGuid + " on saasUsername " + saasUsername);
            return true;
        }
        return false;
    }

    private void collectAttributeSyncEvents(boolean groupMembershipControlledByUserAttrs, boolean usersNeedReprovisioningToUpdateGroupMembership, boolean groupsNeedReprovisioning, Set<String> usersToIgnore) throws DirectoryException {
        VariableStoreVariable checkpoint = new VariableStoreVariable(this._variableStore, VAR_ATTRIB_SYNC_LAST_TIMESTAMP);
        ResourceCallbackCriteria criteria = new ResourceCallbackCriteria();
        criteria.setFilterCriterion(this._directoryDriver.getChangedResourceFilter(checkpoint));
        AttributeSyncCallback userCallback = new AttributeSyncCallback(this._directoryDriver, this._identityMapper, this._userStore, this._clusterManager, usersToIgnore, this.getProvisioningEventLogger());
        boolean usersNeedReprovisioning = false;
        if (groupMembershipControlledByUserAttrs && (usersNeedReprovisioningToUpdateGroupMembership || this._directoryDriver.hasGroupMembershipChanged(checkpoint))) {
            usersNeedReprovisioning = true;
            userCallback.setIgnoreValuesHash(true);
        }
        this.getProvisioningEventLogger().startAttributeSync();
        _logger.info("Starting Attribute update detection stage");
        if (usersNeedReprovisioning) {
            this.processUsers(userCallback);
        } else {
            this.processUsers(userCallback, criteria);
        }
        if (this.isGroupProvisioningEnabled()) {
            boolean usingDnAsGroupName = this.isUsingDnAsGroupName();
            boolean processSubGroupMembshipOnGroups = !groupMembershipControlledByUserAttrs && this._hasSubGroupColumn;
            SecondPhaseDirectoryGroupWorker secondGroupWorker = null;
            if (processSubGroupMembshipOnGroups) {
                Filter groupFilterForGroups = null;
                String groupDnForGroups = null;
                if (this.isUsingGroupDnForGroups()) {
                    if (this._groupNestedSearch) {
                        groupFilterForGroups = Filter.createEqualityFilter((String)this._directoryDriver.getNestedMemberOfGroupAttributeName(), (String)this._passiveProvisioningGroupDnForGroups);
                    } else {
                        groupDnForGroups = this._passiveProvisioningGroupDnForGroups;
                    }
                } else {
                    groupFilterForGroups = this._passiveProvisioningGroupFilterForGroups;
                }
                secondGroupWorker = new SecondPhaseDirectoryGroupWorker(this._groupStore, this._groupMembershipStore, this._clusterManager, usingDnAsGroupName, this._directoryDriver, groupFilterForGroups, groupDnForGroups);
            }
            Filter filterForUsers = null;
            String groupDnForUsers = null;
            if (this.isUsingGroupDnForUsers()) {
                if (this._userNestedSearch) {
                    filterForUsers = Filter.createEqualityFilter((String)this._directoryDriver.getNestedMemberOfGroupAttributeName(), (String)this._passiveProvisioningGroupDnForUsers);
                } else {
                    groupDnForUsers = this._passiveProvisioningGroupDnForUsers;
                }
            } else {
                filterForUsers = this._passiveProvisioningFilterForUsers;
            }
            DirectoryGroupWorker groupWorker = new DirectoryGroupWorker(this._groupStore, this._groupMembershipStore, this._clusterManager, usingDnAsGroupName, !groupMembershipControlledByUserAttrs, this._directoryDriver, filterForUsers, groupDnForUsers, secondGroupWorker, false, this._transactionTemplate, this.getProvisioningEventLogger());
            _logger.debug("\tCollecting changed groups...");
            TinyHashSet cleanGroupsAfterFirstPhase = new TinyHashSet();
            GroupSyncCallback groupCallback = new GroupSyncCallback(this._directoryDriver, this._groupStore, groupWorker, processSubGroupMembshipOnGroups, (TinyHashSet<String>)cleanGroupsAfterFirstPhase);
            if (groupsNeedReprovisioning) {
                this.processGroupsInOneStep(groupCallback, !groupMembershipControlledByUserAttrs);
            } else {
                this.processGroupsInOneStep(groupCallback, !groupMembershipControlledByUserAttrs, criteria);
            }
        }
        this._directoryDriver.saveChangedResourceCheckpoint(checkpoint);
        this.getProvisioningEventLogger().logAttributeSyncSummary();
    }

    private void clearDirtyUsers(Set<String> usersToSkip) throws SaasException {
        SaasProvisionableResourceCallback callback = this._maxSaasThreads > 1 ? new AsynchronousSaasCallback(this._saasDriver, this._maxSaasThreads, this._clusterManager, null, this._timeout, this.getProvisioningEventLogger()) : new SynchronousSaasCallback(this._saasDriver, this._timeout * 1000, this._clusterManager, null, this.getProvisioningEventLogger());
        try {
            callback.start();
            try {
                this._userStore.processDirty(callback, this._identityMapper, usersToSkip);
            }
            finally {
                callback.stop();
            }
        }
        catch (SaasException e) {
            _logger.error("Exception during dirty user records cleanup phase!", (Throwable)e);
            throw e;
        }
    }

    private void clearDirtyGroups() {
        _logger.debug("\tClearing dirty group records...");
        Set<String> provisionedGroups = this._groupStore.getAllProvisionedGroupDsGuidsInCycle();
        SaasProvisionableResourceCallback callback = this._maxSaasThreads > 1 ? new AsynchronousSaasCallback(this._saasDriver, this._maxSaasThreads, this._clusterManager, provisionedGroups, this._timeout, this.getProvisioningEventLogger()) : new SynchronousSaasCallback(this._saasDriver, (long)this._timeout * 1000L, this._clusterManager, provisionedGroups, this.getProvisioningEventLogger());
        try {
            callback.start();
            try {
                this._groupStore.processDirty(callback, this._identityMapper.getMaskedFields());
            }
            finally {
                callback.stop();
            }
        }
        catch (SaasException e) {
            _logger.error("Exception during dirty group records cleanup phase!", (Throwable)e);
        }
    }

    private boolean passiveProvisioningNeeded(DelayedVariableUpdater groupTimestampUpdater) throws DirectoryException {
        if (!this.isUsingGroupDnForUsers()) {
            return true;
        }
        if (this._userStore.getDirtyUserCount() > 0) {
            return true;
        }
        Date currentTimestamp = this.getDirectoryDriver().getGroupModifyTime(this._passiveProvisioningGroupDnForUsers, this._userNestedSearch);
        if (currentTimestamp == null) {
            return true;
        }
        _logger.info("Current timestamp for group: " + this._passiveProvisioningGroupDnForUsers + " is " + currentTimestamp);
        Date lastTimestamp = groupTimestampUpdater.getStoreDateValue();
        if (lastTimestamp == null) {
            _logger.info("No timestamp found persisted for group: " + this._passiveProvisioningGroupDnForUsers);
            lastTimestamp = new Date(0L);
        } else {
            _logger.info("Previous persisted timestamp for group: " + this._passiveProvisioningGroupDnForUsers + " is " + lastTimestamp);
        }
        if (currentTimestamp.after(lastTimestamp)) {
            groupTimestampUpdater.setFutureValue(currentTimestamp);
            return true;
        }
        return false;
    }

    private boolean attributeSyncNeeded() {
        return this._enableAttributeSync;
    }

    public void setGroupMembershipStore(GroupMembershipStore jdbcGroupMembershipStore) {
        this._groupMembershipStore = jdbcGroupMembershipStore;
    }

    private boolean isUsingGroupDnForGroups() {
        return this._passiveProvisioningGroupFilterForGroups == null;
    }

    private boolean isUsingGroupDnForUsers() {
        return this._passiveProvisioningFilterForUsers == null;
    }

    public boolean isUsingDnAsGroupName() {
        if (this._saasDriver instanceof SaasProvisionerPluginGroupsWithMembersExt) {
            return ((SaasProvisionerPluginGroupsWithMembersExt)((Object)this._saasDriver)).isUsingDnAsGroupName();
        }
        return false;
    }

    public void setUserNestedSearch(boolean _usersNestedSearch) {
        this._userNestedSearch = _usersNestedSearch;
    }

    public void setGroupNestedSearch(boolean groupNestedSearch) {
        this._groupNestedSearch = groupNestedSearch;
    }

    public void setSubGroupColumn(boolean hasSubGroupColumn) {
        this._hasSubGroupColumn = hasSubGroupColumn;
    }

    public void setIdentityMappingHash(String hash) {
        this._identityMappingHash = hash;
    }
}

