/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.channel;

import com.pingidentity.provisioner.cluster.ClusteringException;
import com.pingidentity.provisioner.cluster.ProvisionerClusterManager;
import com.pingidentity.provisioner.directory.DirectoryDriver;
import com.pingidentity.provisioner.directory.DirectoryException;
import com.pingidentity.provisioner.directory.DirectoryResourceCallback;
import com.pingidentity.provisioner.directory.DirectoryResourceGuidCallback;
import com.pingidentity.provisioner.identity.DirectoryIdentity;
import com.pingidentity.provisioner.identity.SaasIdentity;
import com.pingidentity.provisioner.mapping.IdentityMapper;
import com.pingidentity.provisioner.mapping.MappingException;
import com.pingidentity.provisioner.monitor.ProvisioningEventLogger;
import com.pingidentity.provisioner.store.DuplicateKeyException;
import com.pingidentity.provisioner.store.InvalidProvisioningDataException;
import com.pingidentity.provisioner.store.UserStore;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PassiveProvisioningCallback
extends DirectoryResourceGuidCallback {
    private static Logger _logger = LogManager.getLogger(PassiveProvisioningCallback.class);
    private Set<String> _insideGuids;
    private Set<String> _outsideGuids;
    private Set<String> _confilictedSaasUsernames;
    private UserStore _userStore;
    private DirectoryDriver _directoryDriver;
    private IdentityMapper _identityMapper;
    private ProvisionerClusterManager _clusterManager;
    private List<DirectoryResourceCallback.DirectoryCallbackProcessException> _nonFatalExceptions = new LinkedList<DirectoryResourceCallback.DirectoryCallbackProcessException>();
    private final Set<String> _attributeNames = new HashSet<String>();
    private boolean hasUsersBeenAddedRemoved = false;
    private Set<String> _usersToIgnore;
    Map<String, Integer> _unManagedUsers;
    private final ProvisioningEventLogger _provisioningEventLogger;

    public PassiveProvisioningCallback(Set<String> insideGuids, Set<String> outsideGuids, Set<String> conflictedSaasNames, UserStore userStore, DirectoryDriver directoryDriver, IdentityMapper identityMapper, ProvisionerClusterManager clusterManager, Set<String> usersToIgnore, Map<String, Integer> unManagedUsers, ProvisioningEventLogger provisioningEventLogger) {
        super(directoryDriver.getGuidFormatter());
        this._insideGuids = insideGuids;
        this._outsideGuids = outsideGuids;
        this._confilictedSaasUsernames = conflictedSaasNames;
        this._userStore = userStore;
        this._directoryDriver = directoryDriver;
        this._identityMapper = identityMapper;
        this._clusterManager = clusterManager;
        this._attributeNames.addAll(identityMapper.getAttributeNames());
        this._attributeNames.add(this._directoryDriver.getChangedResourceAttribute());
        this._usersToIgnore = usersToIgnore;
        this._unManagedUsers = unManagedUsers;
        this._provisioningEventLogger = provisioningEventLogger;
    }

    @Override
    public void process(String dn, String guid) throws DirectoryException, ClusteringException {
        if (this.ignoreUser(guid)) {
            _logger.debug("Skipping user " + guid + " as they are managed by another channel");
            this._provisioningEventLogger.passiveProvUserSkipped();
        } else {
            this._clusterManager.sendHeartBeat();
            if (this._insideGuids.contains(guid)) {
                this._insideGuids.remove(guid);
                this._provisioningEventLogger.passiveProvUserProcessed();
            } else if (this._outsideGuids.contains(guid)) {
                this.updateUserstore(false, guid, dn);
                this._outsideGuids.remove(guid);
                this.hasUsersBeenAddedRemoved = true;
                this._provisioningEventLogger.passiveProvUserAdded();
            } else {
                if (this._unManagedUsers.containsKey(guid)) {
                    int oldChannel = this._unManagedUsers.get(guid);
                    this.changeChannelForUser(guid, dn, oldChannel);
                    this._unManagedUsers.remove(guid);
                } else {
                    this.updateUserstore(true, guid, dn);
                }
                this._provisioningEventLogger.passiveProvUserAdded();
                this.hasUsersBeenAddedRemoved = true;
            }
        }
    }

    @Override
    public List<DirectoryResourceCallback.DirectoryCallbackProcessException> getNonFatalExceptions() {
        return this._nonFatalExceptions;
    }

    private void updateUserstore(boolean create, String guid, String dn) throws DirectoryException {
        DirectoryIdentity directoryIdentity = this._directoryDriver.loadUserByDn(this._attributeNames, dn);
        SaasIdentity saasIdentity = this.convert(directoryIdentity, dn);
        if (saasIdentity == null) {
            return;
        }
        try {
            if (create) {
                this._userStore.create(guid, saasIdentity, true);
            } else {
                this._userStore.update(guid, saasIdentity, true);
            }
        }
        catch (DuplicateKeyException e) {
            this._confilictedSaasUsernames.add(e.getConflictValue());
            this._nonFatalExceptions.add(new DirectoryResourceCallback.DirectoryCallbackProcessException("User " + (create ? "insert" : "update") + " skipped for GUID: " + guid + " collision with " + e.getConflictValue(), e));
        }
        catch (InvalidProvisioningDataException e) {
            this._nonFatalExceptions.add(new DirectoryResourceCallback.DirectoryCallbackProcessException("User " + (create ? "insert" : "update") + " skipped for GUID: " + guid + ". Unable to update database due to data violation. " + e.getMessage(), e));
        }
        this._directoryDriver.processChangedResource(directoryIdentity);
    }

    private void changeChannelForUser(String dsGuid, String dn, int oldChannel) throws DirectoryException {
        _logger.debug("Reassigning user " + dsGuid + " to this channel");
        DirectoryIdentity directoryIdentity = this._directoryDriver.loadUserByDn(this._attributeNames, dn);
        SaasIdentity saasIdentity = this.convert(directoryIdentity, dn);
        try {
            this._userStore.updateChannel(dsGuid, saasIdentity, true, oldChannel);
        }
        catch (DuplicateKeyException e) {
            this._confilictedSaasUsernames.add(e.getConflictValue());
            this._nonFatalExceptions.add(new DirectoryResourceCallback.DirectoryCallbackProcessException("User update skipped for GUID: " + dsGuid + " collision with " + e.getConflictValue(), e));
        }
        catch (InvalidProvisioningDataException e) {
            this._nonFatalExceptions.add(new DirectoryResourceCallback.DirectoryCallbackProcessException("User update skipped for GUID: " + dsGuid + ". Unable to update database due to data violation. " + e.getMessage(), e));
        }
        this._directoryDriver.processChangedResource(directoryIdentity);
    }

    private SaasIdentity convert(DirectoryIdentity directoryIdentity, String dn) throws DirectoryException {
        try {
            return this._identityMapper.map(directoryIdentity);
        }
        catch (MappingException e) {
            this._nonFatalExceptions.add(new DirectoryResourceCallback.DirectoryCallbackProcessException("Directory server user at " + dn + " cannot be mapped!", e));
            return null;
        }
    }

    public boolean hasUsersBeenAddedRemoved() {
        return this.hasUsersBeenAddedRemoved;
    }

    private boolean ignoreUser(String guid) {
        if (this._usersToIgnore == null) {
            return false;
        }
        return this._usersToIgnore.contains(guid);
    }
}

