/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.channel;

import com.pingidentity.provisioner.channel.AddMembershipCallback;
import com.pingidentity.provisioner.cluster.ClusteringException;
import com.pingidentity.provisioner.cluster.ProvisionerClusterManager;
import com.pingidentity.provisioner.directory.DirectoryDriver;
import com.pingidentity.provisioner.directory.DirectoryException;
import com.pingidentity.provisioner.directory.DirectoryResourceCallback;
import com.pingidentity.provisioner.directory.ResourceCallbackCriteria;
import com.pingidentity.provisioner.identity.DirectoryGroup;
import com.pingidentity.provisioner.identity.SaasGroup;
import com.pingidentity.provisioner.mapping.GroupMapper;
import com.pingidentity.provisioner.store.groups.GroupMembershipStore;
import com.pingidentity.provisioner.store.groups.GroupStore;
import com.unboundid.ldap.sdk.Filter;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class SecondPhaseDirectoryGroupWorker {
    private final GroupStore groupStore;
    private final GroupMembershipStore groupMembershipStore;
    private final ProvisionerClusterManager clusterManager;
    private final List<DirectoryResourceCallback.DirectoryCallbackProcessException> nonFatalExceptions = new LinkedList<DirectoryResourceCallback.DirectoryCallbackProcessException>();
    private final DirectoryDriver directoryDriver;
    private final Filter groupsFilter;
    private final String groupsGroup;
    private final Set<String> attributeNames = new HashSet<String>();
    private final GroupMapper groupMapper;

    public SecondPhaseDirectoryGroupWorker(GroupStore groupStore, GroupMembershipStore groupMembershipStore, ProvisionerClusterManager clusterManager, boolean usingDnAsGroupName, DirectoryDriver directoryDriver, Filter groupsFilter, String groupsGroup) {
        this.groupStore = groupStore;
        this.groupMembershipStore = groupMembershipStore;
        this.clusterManager = clusterManager;
        this.directoryDriver = directoryDriver;
        this.groupsFilter = groupsFilter;
        this.groupsGroup = groupsGroup;
        this.groupMapper = new GroupMapper(usingDnAsGroupName);
        this.attributeNames.add(directoryDriver.getGuidFormatter().getGuidAttributeName());
        this.attributeNames.addAll(this.groupMapper.getLdapAttributeNames());
    }

    public void work(String dn, DirectoryGroup directoryGroup) throws DirectoryException, ClusteringException {
        this.clusterManager.sendHeartBeat();
        String guid = directoryGroup.getGuid();
        SaasGroup saasGroup = this.groupMapper.map(dn, directoryGroup);
        AddMembershipCallback addMembershipCallback = new AddMembershipCallback(this.directoryDriver.getGuidFormatter(), guid, this.groupMembershipStore, false);
        ResourceCallbackCriteria callbackCriteria = new ResourceCallbackCriteria();
        callbackCriteria.setGroupCriterion(this.groupsGroup);
        callbackCriteria.setObjectClassCriterion(this.directoryDriver.getGroupObjectClass());
        callbackCriteria.setFilterCriterion(this.groupsFilter);
        this.directoryDriver.processResourcesInGroup(dn, callbackCriteria, addMembershipCallback);
        this.nonFatalExceptions.addAll(addMembershipCallback.getNonFatalExceptions());
        this.groupStore.updateValuesHashWithMembers(saasGroup);
    }

    public List<DirectoryResourceCallback.DirectoryCallbackProcessException> getNonFatalExceptions() {
        return this.nonFatalExceptions;
    }

    public Set<String> getAttributeNames() {
        return this.attributeNames;
    }
}

