/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.channel.asynchronous;

import com.pingidentity.provisioner.channel.asynchronous.AsynchronousSaasGroupRunner;
import com.pingidentity.provisioner.channel.asynchronous.AsynchronousSaasRunner;
import com.pingidentity.provisioner.channel.asynchronous.AsynchronousSaasUserRunner;
import com.pingidentity.provisioner.channel.synchronous.SynchronousSaasCallback;
import com.pingidentity.provisioner.cluster.ProvisionerClusterManager;
import com.pingidentity.provisioner.identity.SaasGroup;
import com.pingidentity.provisioner.identity.SaasIdentity;
import com.pingidentity.provisioner.monitor.ProvisioningEventLogger;
import com.pingidentity.provisioner.resources.SaasProvisionableResource;
import com.pingidentity.provisioner.saas.SaasException;
import com.pingidentity.provisioner.saas.SaasProvisionerPlugin;
import com.pingidentity.provisioner.store.DataStoreUpdater;
import com.pingidentity.provisioner.store.SaasProvisionableResourceCallback;
import com.pingidentity.provisioner.store.UserStoreUpdater;
import java.time.Duration;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;

public class AsynchronousSaasCallback
implements SaasProvisionableResourceCallback {
    private static Logger _logger = LogManager.getLogger(AsynchronousSaasCallback.class);
    private final ConfigStore configStore = ConfigStoreFarm.getConfig((String)"com.pingidentity.provisioner.channel.asynchronous.AsynchronousSaasCallback");
    private ThreadPoolExecutor _threadPoolExecutor;
    private int _maxThreads;
    private SynchronousSaasCallback _synchronousCallback;
    private volatile boolean _stopSession = false;

    public AsynchronousSaasCallback(SaasProvisionerPlugin saasDriver, int maxThreads, ProvisionerClusterManager clusterManager, Set<String> provisionedGroups, int timeout, ProvisioningEventLogger _provisioningEventLogger) {
        this(saasDriver, maxThreads, timeout, clusterManager, provisionedGroups, _provisioningEventLogger);
    }

    public AsynchronousSaasCallback(SaasProvisionerPlugin saasDriver, int maxThreads, int maxSaasCallSeconds, ProvisionerClusterManager clusterManager, Set<String> provisionedGroups, ProvisioningEventLogger _provisioningEventLogger) {
        this._maxThreads = maxThreads;
        this._synchronousCallback = new SynchronousSaasCallback(saasDriver, maxSaasCallSeconds * 1000, clusterManager, provisionedGroups, _provisioningEventLogger);
    }

    void stopSession() {
        this._stopSession = true;
    }

    boolean isStopSession() {
        return this._stopSession;
    }

    @Override
    public void start() throws SaasException {
        this._synchronousCallback.start();
        this._threadPoolExecutor = (ThreadPoolExecutor)Executors.newFixedThreadPool(this._maxThreads);
    }

    @Override
    public void stop() throws SaasException {
        this._threadPoolExecutor.shutdown();
        try {
            long timeoutSecs = this.configStore.getLongValue("AsyncCycleTimeoutSeconds", Duration.ofDays(30L).getSeconds());
            if (!this._threadPoolExecutor.awaitTermination(timeoutSecs, TimeUnit.SECONDS)) {
                this._threadPoolExecutor.shutdownNow();
                _logger.error("Thread pool shutdown forcefully!");
                throw new SaasException("Thread pool shutdown forcefully!");
            }
        }
        catch (InterruptedException e) {
            _logger.error("Waiting for thread pool shutdown interrupted!");
        }
        finally {
            this._synchronousCallback.stop();
        }
    }

    @Override
    public void process(SaasProvisionableResource provisionableResource, DataStoreUpdater updater, String sourceGuid) throws SaasException {
        AsynchronousSaasRunner runnable = null;
        if (provisionableResource instanceof SaasIdentity) {
            runnable = new AsynchronousSaasUserRunner(this._synchronousCallback, this, (SaasIdentity)provisionableResource, (UserStoreUpdater)updater, sourceGuid);
        } else if (provisionableResource instanceof SaasGroup) {
            runnable = new AsynchronousSaasGroupRunner(this._synchronousCallback, this, (SaasGroup)provisionableResource, updater, sourceGuid);
        } else {
            throw new SaasException("Unable to start AsynchronousSaasRunner thread. provisionableResource is not of a supported type: " + provisionableResource.toString());
        }
        this._threadPoolExecutor.submit(runnable);
    }
}

