/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.channel.runner;

import com.pingidentity.common.util.AbstractFileWatcher;
import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.common.util.TimerTaskBase;
import com.pingidentity.provisioner.ProvisioningException;
import com.pingidentity.provisioner.channel.ProvisioningChannel;
import com.pingidentity.provisioner.channel.runner.ChannelFactory;
import com.pingidentity.provisioner.channel.runner.SequentialChannelRunner;
import com.pingidentity.provisioner.cluster.ClusteringException;
import com.pingidentity.provisioner.cluster.ProvisionerClusterManager;
import com.pingidentity.provisioner.cluster.ProvisionerClusterManagerFactory;
import com.pingidentity.provisioner.domain.ProvisionerGlobalSettings;
import com.pingidentity.provisioner.domain.mgmt.ProvisionerManager;
import com.pingidentity.provisioner.monitor.SaasProvisioningEventTracker;
import com.pingidentity.provisioner.monitor.SaasProvisioningEventTrackerLog4jImpl;
import com.pingidentity.provisioner.saas.SaasException;
import com.pingidentity.provisioner.store.jdbc.JdbcProvisionerNodeStateDataManager;
import com.pingidentity.provisioner.util.DataSourceInitializer;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.JdbcDataSource;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.service.util.Node;
import org.sourceid.saml20.service.util.NodeIndexRegistry;
import org.sourceid.util.license.LicenseManager;
import org.sourceid.util.license.PingLicense;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.jdbc.support.MetaDataAccessException;
import org.springframework.jndi.JndiTemplate;
import org.springframework.transaction.PlatformTransactionManager;

public class ProvisionerRunner {
    private static Logger _logger = LogManager.getLogger(ProvisionerRunner.class);
    private static final long CONFIG_WATCHER_DELAY_MILLIS = 10000L;
    private static final long CONFIG_WATCHER_PERIOD_MILLIS = 5000L;
    private ProvisionerGlobalSettings _provisionerGlobalSettings = ProvisionerManager.getProvisionerGlobalSettings();
    private SaasProvisioningEventTracker _eventTracker = new SaasProvisioningEventTrackerLog4jImpl();
    private final Timer _timer = new Timer("SequentialChannelRunner", true);
    private SequentialChannelRunner _channelRunnerTask = null;

    public void init() {
        TimerTaskBase provisionerInitTask = new TimerTaskBase(){

            public void doTask() {
                try {
                    ProvisionerRunner.this._init();
                }
                catch (Exception e) {
                    _logger.fatal("Provisioner failed to initialize due to an exception: " + e.getMessage(), (Throwable)e);
                }
            }
        };
        Timer timer = new Timer("ProvisionerInitTask", true);
        timer.schedule((TimerTask)provisionerInitTask, 0L);
    }

    public void _init() throws NamingException, ProvisioningException, InterruptedException, MetaDataAccessException {
        String mode = System.getProperty("pf.provisioner.mode", "").trim();
        if (mode.length() == 0) {
            _logger.fatal("Provisioner disabled. Mode not set: pf.provisioner.mode");
        } else if ("standalone".equalsIgnoreCase(mode) || "failover".equalsIgnoreCase(mode)) {
            this.waitForDataSources();
            this.waitForLicense();
            _logger.info("Scheduling provisioner channels...");
            this.scheduleChannelRunner();
            this.startFileWatchingTask();
        } else if ("off".equalsIgnoreCase(mode)) {
            _logger.info("Provisioner disabled.");
        } else {
            _logger.fatal("Provisioner disabled. Unknown mode: " + mode);
        }
    }

    public boolean isProvisionerNodeDefined() {
        boolean provisioningNodeDefined;
        String currentMode = StringUtils.trim((String)System.getProperty("pf.provisioner.mode"));
        boolean bl = provisioningNodeDefined = "standalone".equalsIgnoreCase(currentMode) || "failover".equalsIgnoreCase(currentMode);
        if (!provisioningNodeDefined && MgmtFactory.getMediator().isDistributable()) {
            NodeIndexRegistry idxReg = (NodeIndexRegistry)GlobalRegistry.getService(NodeIndexRegistry.class);
            for (Node node : idxReg.getNodes()) {
                String nodeProvisionerMode = node.getProvisionerClusterMode();
                if (!"standalone".equalsIgnoreCase(nodeProvisionerMode) && !"failover".equalsIgnoreCase(nodeProvisionerMode)) continue;
                provisioningNodeDefined = true;
                break;
            }
        }
        return provisioningNodeDefined;
    }

    public void activateProvisionerIfNecessary() throws Exception {
        if (!this.isProvisionerNodeDefined()) {
            String newMode = "standalone".toUpperCase();
            System.setProperty("pf.provisioner.mode", newMode);
            _logger.info("No provisioner node detected, setting pf.provisioner.mode in run.properties to " + newMode);
            try {
                PropertyInfo.updateRunProperties((String)"pf.provisioner.mode", (String)newMode);
            }
            catch (IOException e) {
                throw new ProvisioningException("Failed to update run.properties with new value for pf.provisioner.mode", e);
            }
            this.init();
        }
    }

    private boolean usingEmbeddedHsqldb() {
        DataSourceManager dataSourceManager = MgmtFactory.getDataSourceManager();
        JdbcDataSource jdbcDataSource = dataSourceManager.getJdbcDataSource(this._provisionerGlobalSettings.getInternalDataSourceId());
        return jdbcDataSource.isEmbeddedHsqldb();
    }

    public void destroy() throws SaasException {
        _logger.info("Provisioner runner shutting down...");
        this._timer.cancel();
        if (this._channelRunnerTask != null) {
            this._channelRunnerTask.stopChannels();
        }
    }

    private void scheduleChannelRunner() throws NamingException, ClusteringException, MetaDataAccessException {
        String mode = System.getProperty("pf.provisioner.mode", "").trim();
        this._provisionerGlobalSettings = ProvisionerManager.getProvisionerGlobalSettings();
        if (this._provisionerGlobalSettings != null && this._provisionerGlobalSettings.getInternalDataSourceJNDIName() != null) {
            if (this._provisionerGlobalSettings.isEnabledInGui()) {
                if ("failover".equalsIgnoreCase(mode) && this.usingEmbeddedHsqldb()) {
                    _logger.fatal("Provisioner cannot be run in failover mode using the embedded Hypersonic database!");
                } else {
                    DataSource dataSource = this.createDataSource();
                    ProvisionerClusterManager clusterManager = this.createClusterManager(dataSource);
                    List<ProvisioningChannel> channels = this.createChannelFactory(clusterManager, dataSource).createActiveChannels();
                    long periodMillis = (long)this._provisionerGlobalSettings.getSyncInterval() * 1000L;
                    this._channelRunnerTask = new SequentialChannelRunner(channels, periodMillis, clusterManager, this._eventTracker);
                    this._channelRunnerTask.startChannels();
                    this._timer.schedule((TimerTask)this._channelRunnerTask, periodMillis, periodMillis);
                }
            } else {
                _logger.warn("Outbound Provisioning disabled! Please enable in the Admin UI if you want to use provisioning.");
            }
        } else {
            _logger.fatal("The provisioner is not properly configured.");
        }
    }

    private void startFileWatchingTask() {
        String dataDir = System.getProperty("pf.server.data.dir");
        AbstractFileWatcher configWatcherTask = new AbstractFileWatcher(Arrays.asList(new File(dataDir, "module/saas-provisioner.xml"), new File(dataDir, "module/provisioner-notify.txt"))){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void onModified() {
                try {
                    Timer timer = ProvisionerRunner.this._timer;
                    synchronized (timer) {
                        _logger.info("Reloader, refreshing provisioner channel runner!");
                        if (ProvisionerRunner.this._channelRunnerTask != null) {
                            ProvisionerRunner.this._channelRunnerTask.cancel();
                            ProvisionerRunner.this._channelRunnerTask.stopChannels();
                        }
                        ProvisionerRunner.this._timer.purge();
                        ProvisionerRunner.this._provisionerGlobalSettings = ProvisionerManager.getProvisionerGlobalSettings();
                        ProvisionerRunner.this.scheduleChannelRunner();
                    }
                }
                catch (Exception e) {
                    _logger.error("Cannot restart channel runner!", (Throwable)e);
                }
            }
        };
        Timer timer = new Timer("ProvisionerConfigWatcher", true);
        timer.schedule((TimerTask)configWatcherTask, 10000L, 5000L);
    }

    private DataSource createDataSource() throws NamingException {
        MgmtFactory.getDataSourceManager().initializeJndiLookup();
        JndiTemplate jndiTemplate = new JndiTemplate();
        return (DataSource)jndiTemplate.lookup(this._provisionerGlobalSettings.getInternalDataSourceJNDIName());
    }

    private ProvisionerClusterManager createClusterManager(DataSource dataSource) throws ClusteringException {
        JdbcProvisionerNodeStateDataManager dataAccessManager = new JdbcProvisionerNodeStateDataManager(dataSource);
        DataSourceTransactionManager transactionManager = new DataSourceTransactionManager();
        transactionManager.setDataSource(dataSource);
        ProvisionerClusterManagerFactory clusterManagerFactory = new ProvisionerClusterManagerFactory();
        clusterManagerFactory.setDataAccessManager(dataAccessManager);
        clusterManagerFactory.setSyncInterval(this._provisionerGlobalSettings.getSyncInterval());
        clusterManagerFactory.setTransactionManager((PlatformTransactionManager)transactionManager);
        return clusterManagerFactory.createFromSystemProperties();
    }

    private ChannelFactory createChannelFactory(ProvisionerClusterManager clusterManager, DataSource dataSource) {
        ChannelFactory channelFactory = new ChannelFactory();
        channelFactory.setEventTracker(this._eventTracker);
        channelFactory.setClusterManager(clusterManager);
        channelFactory.setInternalDataSource(dataSource);
        channelFactory.setTransactionManager((PlatformTransactionManager)new DataSourceTransactionManager(dataSource));
        return channelFactory;
    }

    private void waitForDataSources() throws NamingException, ProvisioningException, InterruptedException {
        DataSourceInitializer initializer = new DataSourceInitializer();
        initializer.setDsName(this._provisionerGlobalSettings.getInternalDataSourceJNDIName());
        initializer.init();
    }

    private void waitForLicense() {
        PingLicense license = LicenseManager.getLicense();
        while (!this.checkLicense(license)) {
            while (!license.isChanged()) {
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            license = LicenseManager.getLicense();
        }
    }

    private boolean checkLicense(PingLicense license) {
        if (LicenseManager.getStatus().isLockdownRuntime()) {
            _logger.info("Your Pingfederate Server is in violation of the license terms. The server has stopped processing.");
        } else {
            if (license.isFeatureEnabled("SaasProvisioning")) {
                return true;
            }
            _logger.fatal("You do not have a valid license for Outbound Provisioning. To obtain a valid license, please contact your vendor's Customer Support.");
        }
        return false;
    }
}

