/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.cli;

import com.pingidentity.common.util.access.ExecutionContext;
import com.pingidentity.common.util.access.ExecutionContextManager;
import com.pingidentity.provisioner.cli.CliArgumentException;
import com.pingidentity.provisioner.cli.CliException;
import com.pingidentity.provisioner.cli.Command;
import com.pingidentity.provisioner.domain.Channel;
import com.pingidentity.provisioner.domain.mgmt.ProvisionerConfig;
import com.pingidentity.provisioner.domain.mgmt.ProvisionerManager;
import com.pingidentity.provisioner.domain.source.ChannelSource;
import com.pingidentity.provisioner.resources.SaasProvisionableResource;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public abstract class BaseCommand
implements Command {
    protected Option _option;
    protected PrintStream _out = System.out;
    protected PrintStream _err = System.err;
    protected Option _channelIdOption;
    protected Option _nodeIdOption;
    protected Option _saasUsernameOption;
    protected Option _ldapGuidOption;

    public BaseCommand() {
        this._option = this.createOption();
        this._channelIdOption = new Option("c", null, true, "Numeric channel ID");
        this._channelIdOption.setArgName("channel id");
        this._nodeIdOption = new Option("n", null, true, "Numeric node ID");
        this._nodeIdOption.setArgName("node id");
        this._saasUsernameOption = new Option("u", null, true, "SaaS name");
        this._saasUsernameOption.setArgName("saas name");
        this._ldapGuidOption = new Option("g", null, true, "LDAP GUID");
        this._ldapGuidOption.setArgName("ldap guid");
    }

    protected abstract Option createOption();

    @Override
    public List<Option> getOptions() {
        ArrayList<Option> options = new ArrayList<Option>(5);
        options.add(this._option);
        options.add(this._channelIdOption);
        options.add(this._nodeIdOption);
        options.add(this._saasUsernameOption);
        options.add(this._ldapGuidOption);
        return options;
    }

    @Override
    public void init() throws CliException {
        ExecutionContextManager.setCurrentExecutionContext((ExecutionContext)ExecutionContext.PROVISIONER);
    }

    @Override
    public void destroy() throws CliException {
    }

    @Override
    public boolean shouldExecute(CommandLine cli) {
        if (this._option.hasLongOpt()) {
            return cli.hasOption(this._option.getLongOpt());
        }
        String shortOption = this._option.getOpt();
        return shortOption != null && cli.hasOption(shortOption);
    }

    protected Vector<Integer> calculateWidths(List<Vector<String>> rows, int columnCount) {
        Vector<Integer> widths = new Vector<Integer>(columnCount);
        for (int i = 0; i < columnCount; ++i) {
            int width = 0;
            for (Vector<String> row : rows) {
                String cell = row.get(i);
                if (cell == null) continue;
                width = Math.max(width, cell.length());
            }
            widths.add(width);
        }
        return widths;
    }

    protected Vector<String> createUnderlines(Vector<String> header) {
        Vector<String> underlines = new Vector<String>(header.size());
        for (String colHeader : header) {
            underlines.add(StringUtils.repeat((String)"-", (int)colHeader.length()));
        }
        return underlines;
    }

    protected void printTable(Vector<String> header, List<Vector<String>> data, int columnCount) {
        ArrayList<Vector<String>> table = new ArrayList<Vector<String>>(2 + data.size());
        if (header != null) {
            table.add(header);
            table.add(this.createUnderlines(header));
        }
        table.addAll(data);
        Vector<Integer> widths = this.calculateWidths(table, columnCount);
        for (Vector vector : table) {
            for (int i = 0; i < columnCount; ++i) {
                this._out.print(String.format("%1$" + widths.get(i) + "s", vector.get(i)));
                this._out.print(' ');
            }
            this._out.println();
        }
    }

    protected void printNameValueTable(String title, List<Vector<String>> data) {
        if (title != null) {
            this._out.println(title);
            this._out.println(StringUtils.repeat((String)"-", (int)title.length()));
        }
        this.printTable(null, data, 2);
    }

    protected void printMappedFields(SaasProvisionableResource resource) {
        this._out.println();
        Set<String> resourceNames = resource.getNames();
        ArrayList<Vector<String>> fieldTable = new ArrayList<Vector<String>>();
        for (String name : resourceNames) {
            if (resource.isMapValue(name)) {
                Map<String, List<String>> mapValue = resource.getMap(name);
                for (Map.Entry<String, List<String>> entry : mapValue.entrySet()) {
                    for (String entryValue : entry.getValue()) {
                        this.addRow(fieldTable, name + "." + entry.getKey(), entryValue);
                    }
                }
                continue;
            }
            for (String value : resource.getValues(name)) {
                this.addRow(fieldTable, name, value);
            }
        }
        this.printNameValueTable("Mapped Fields", fieldTable);
    }

    protected int getChannelId(CommandLine cli) throws CliException {
        return this.getIntArg(cli, this._channelIdOption);
    }

    protected int getNodeId(CommandLine cli) throws CliException {
        return this.getIntArg(cli, this._nodeIdOption);
    }

    protected String getSaasUsername(CommandLine cli) throws CliException {
        return this.getStringArg(cli, this._saasUsernameOption);
    }

    protected String getLdapGuid(CommandLine cli) throws CliException {
        return this.getStringArg(cli, this._ldapGuidOption);
    }

    private String getStringArg(CommandLine cli, Option option) throws CliException {
        if (cli.hasOption(option.getOpt())) {
            return cli.getOptionValue(option.getOpt());
        }
        throw new CliArgumentException("Missing argument: -" + option.getOpt() + " <" + option.getArgName() + ">");
    }

    private int getIntArg(CommandLine cli, Option option) throws CliException {
        if (cli.hasOption(option.getOpt())) {
            String strValue = cli.getOptionValue(option.getOpt());
            try {
                return Integer.parseInt(strValue);
            }
            catch (NumberFormatException e) {
                throw new CliArgumentException("Invalid " + option.getArgName() + ": " + strValue);
            }
        }
        throw new CliArgumentException("Missing argument: -" + option.getOpt() + " <" + option.getArgName() + ">");
    }

    protected void addRow(List<Vector<String>> table, String name, String value) {
        Vector<Object> row = new Vector<Object>(2);
        row.add(name + ":");
        row.add(value);
        table.add(row);
    }

    protected void addRow(List<Vector<String>> table, String name, boolean value) {
        this.addRow(table, name, value ? "yes" : "no");
    }

    protected ChannelSource getDomainSource(int channelId) throws CliArgumentException {
        return this.getDomainChannel(channelId).getSource();
    }

    protected Channel getDomainChannel(int channelId) throws CliArgumentException {
        for (ProvisionerConfig provisionerConfig : ProvisionerManager.getProvisionerConfigs()) {
            for (Channel dChannel : provisionerConfig.getChannels()) {
                if (channelId != dChannel.getId()) continue;
                return dChannel;
            }
        }
        throw new CliArgumentException("Cannot retrieve source information for channel: " + channelId);
    }

    protected LdapDataSource getDomainLdapDataSource(ChannelSource source) {
        DataSourceManager dataSourceManager = MgmtFactory.getDataSourceManager();
        return dataSourceManager.getLdapDataSource(source.getDataSourceId());
    }
}

