/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.cli;

import com.pingidentity.common.util.ConsoleUtils;
import com.pingidentity.provisioner.cli.ClearDirtyCommand;
import com.pingidentity.provisioner.cli.ClearDirtyGroupsCommand;
import com.pingidentity.provisioner.cli.ClearDirtyUsersCommand;
import com.pingidentity.provisioner.cli.CliArgumentException;
import com.pingidentity.provisioner.cli.CliException;
import com.pingidentity.provisioner.cli.Command;
import com.pingidentity.provisioner.cli.DeleteAllCommand;
import com.pingidentity.provisioner.cli.DeleteAllUsersCommand;
import com.pingidentity.provisioner.cli.DeleteDirtyCommand;
import com.pingidentity.provisioner.cli.DeleteDirtyGroupsCommand;
import com.pingidentity.provisioner.cli.DeleteDirtyUsersCommand;
import com.pingidentity.provisioner.cli.ForceNodeBackupCommand;
import com.pingidentity.provisioner.cli.HelpCommand;
import com.pingidentity.provisioner.cli.ResetAllCommand;
import com.pingidentity.provisioner.cli.ResetAttributeSyncCommand;
import com.pingidentity.provisioner.cli.ResetGroupTimestampCommand;
import com.pingidentity.provisioner.cli.ResetValuesHashCommand;
import com.pingidentity.provisioner.cli.ShowChannelsCommand;
import com.pingidentity.provisioner.cli.ShowDirtyCommand;
import com.pingidentity.provisioner.cli.ShowDirtyGroupsCommand;
import com.pingidentity.provisioner.cli.ShowDirtyUsersCommand;
import com.pingidentity.provisioner.cli.ShowGroupCommand;
import com.pingidentity.provisioner.cli.ShowNodesCommand;
import com.pingidentity.provisioner.cli.ShowSourceCommand;
import com.pingidentity.provisioner.cli.ShowTargetCommand;
import com.pingidentity.provisioner.cli.ShowUserCommand;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommandLineTool {
    private static Logger _logger = LogManager.getLogger(CommandLineTool.class);
    private static Command _helpCommand = new HelpCommand();
    private static List<Command> _commands = new ArrayList<Command>();
    private static final String RUN_PROPERTIES = "run.properties";

    public static void main(String[] args) throws CliException {
        ConsoleUtils.initializeCommandLineProperties();
        try {
            ConsoleUtils.loadRunProperties();
        }
        catch (IOException e) {
            _logger.error("Failed to load run.properties", (Throwable)e);
            System.err.println("Failed to load run.properties: " + e.getMessage());
        }
        ConsoleUtils.checkEnableBCFIPS();
        Options options = CommandLineTool.createOptions();
        try {
            GnuParser cliParser = new GnuParser();
            CommandLine cli = cliParser.parse(options, args, true);
            Object[] leftOverArgs = cli.getArgs();
            if (leftOverArgs.length == 0) {
                CommandLineTool.processCommand(cli, options);
            } else {
                String leftOverArgsStr = StringUtils.join((Object[])leftOverArgs, (char)' ');
                _logger.error("Invalid arguments: " + leftOverArgsStr);
                System.err.println("Invalid arguments: " + leftOverArgsStr);
                _helpCommand.execute(null, options);
            }
        }
        catch (ParseException e) {
            _logger.error("Command line parsing error: " + Arrays.toString(args), (Throwable)e);
            System.err.println("Command line parsing error: " + e.getMessage());
            _helpCommand.execute(null, options);
        }
    }

    private static void loadHivemodule() {
        try {
            ConsoleUtils.loadHivemodule();
        }
        catch (IOException e) {
            _logger.error("Failed to load hivemodule.xml", (Throwable)e);
            System.err.println("Failed to load hivemodule.xml");
        }
    }

    private static void processCommand(CommandLine cli, Options options) throws CliException {
        try {
            for (Command command : _commands) {
                if (!command.shouldExecute(cli)) continue;
                command.init();
                command.execute(cli, options);
                command.destroy();
            }
        }
        catch (CliArgumentException e) {
            _logger.error(e.getMessage(), (Throwable)e);
            System.err.println(e.getMessage());
            _helpCommand.execute(null, options);
        }
        catch (CliException e) {
            _logger.error(e.getMessage(), (Throwable)e);
            System.err.println(e.getMessage());
        }
    }

    private static Options createOptions() {
        Options options = new Options();
        OptionGroup commandGroup = new OptionGroup();
        for (Command command : _commands) {
            List<Option> optionList = command.getOptions();
            for (int i = 0; i < optionList.size(); ++i) {
                Option option = optionList.get(i);
                if (i == 0) {
                    commandGroup.addOption(option);
                    continue;
                }
                options.addOption(option);
            }
        }
        options.addOptionGroup(commandGroup);
        return options;
    }

    public static Properties getRunProperties() throws CliException {
        try {
            Properties run = new Properties();
            String homeDir = System.getProperty("pf.home");
            if (homeDir == null) {
                throw new CliException("PingFederate home dir not set!");
            }
            run.load(new FileInputStream(homeDir + File.separator + "bin" + File.separator + RUN_PROPERTIES));
            return run;
        }
        catch (IOException e) {
            throw new CliException("Cannot load run.properties", e);
        }
    }

    static {
        ConsoleUtils.disableWarning();
        CommandLineTool.loadHivemodule();
        _commands.add(_helpCommand);
        _commands.add(new ShowChannelsCommand());
        _commands.add(new ShowNodesCommand());
        _commands.add(new ResetGroupTimestampCommand());
        _commands.add(new ResetAttributeSyncCommand());
        _commands.add(new ResetValuesHashCommand());
        _commands.add(new ResetAllCommand());
        _commands.add(new ShowDirtyCommand());
        _commands.add(new ShowDirtyUsersCommand());
        _commands.add(new ShowDirtyGroupsCommand());
        _commands.add(new ShowUserCommand());
        _commands.add(new ShowGroupCommand());
        _commands.add(new ClearDirtyCommand());
        _commands.add(new ClearDirtyUsersCommand());
        _commands.add(new ClearDirtyGroupsCommand());
        _commands.add(new DeleteDirtyCommand());
        _commands.add(new DeleteDirtyUsersCommand());
        _commands.add(new DeleteDirtyGroupsCommand());
        _commands.add(new DeleteAllCommand());
        _commands.add(new DeleteAllUsersCommand());
        _commands.add(new ShowSourceCommand());
        _commands.add(new ShowTargetCommand());
        _commands.add(new ForceNodeBackupCommand());
    }
}

