/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.provisioner.cli;

import com.pingidentity.provisioner.cli.CliException;
import com.pingidentity.provisioner.cli.InternalDbCommand;
import com.pingidentity.provisioner.domain.Channel;
import com.pingidentity.provisioner.domain.mgmt.ProvisionerConfig;
import com.pingidentity.provisioner.domain.mgmt.ProvisionerManager;
import com.pingidentity.provisioner.domain.target.SaasTarget;
import com.pingidentity.provisioner.store.UserStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class ShowChannelsCommand
extends InternalDbCommand {
    private static final int COLUMNS = 7;

    @Override
    protected Option createOption() {
        return new Option(null, "show-channels", false, "Show a list of all existing channels.");
    }

    @Override
    public void execute(CommandLine cli, Options options) throws CliException {
        Vector<String> header = new Vector<String>(Arrays.asList("Id", "Name", "Connection", "Status", "Count", "Source", "Target"));
        List<Vector<String>> channels = this.extractChannelsInfo();
        this.printTable(header, channels, 7);
    }

    private List<Vector<String>> extractChannelsInfo() {
        HashMap channelsByEntityId = new HashMap();
        for (ProvisionerConfig provisionerConfig : ProvisionerManager.getProvisionerConfigs()) {
            SaasTarget target = provisionerConfig.getTarget();
            for (Channel dChannel : provisionerConfig.getChannels()) {
                Vector<String> channel = new Vector<String>(7);
                channel.add(Integer.toString(dChannel.getId()));
                channel.add(dChannel.getName());
                channel.add(provisionerConfig.getEntityId());
                channel.add(dChannel.isActive() ? "active" : "inactive");
                channel.add(this.extractCounts(dChannel.getId()));
                channel.add(dChannel.getSource().getDataSourceId());
                channel.add(target.getPluginId());
                ArrayList channels = (ArrayList)channelsByEntityId.get(provisionerConfig.getEntityId());
                if (channels == null) {
                    channels = new ArrayList();
                    channelsByEntityId.put(provisionerConfig.getEntityId(), channels);
                }
                channels.add(channel);
            }
        }
        return channelsByEntityId.values().stream().flatMap(v -> v.stream()).collect(Collectors.toList());
    }

    private String extractCounts(int channelId) {
        UserStore userStore = this.getUserStore(channelId);
        StringBuilder counts = new StringBuilder();
        int userCount = userStore.getUserCount();
        int dirtyCount = userStore.getDirtyUserCount();
        counts.append(Math.max(userCount, dirtyCount));
        counts.append('/');
        counts.append(dirtyCount);
        return counts.toString();
    }
}

